<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Edubin
 */
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Determine sidebar width class
$woo_sidebar_width = Edubin::setting('woo_sidebar_width');

$edubin_wc_sidebar_clm = '';

if ($woo_sidebar_width === 'sidebar_big') {
    $edubin_wc_sidebar_clm = 'edubin-col-lg-4';
} 
elseif ($woo_sidebar_width === 'sidebar_small') {
    $edubin_wc_sidebar_clm = 'edubin-col-lg-3';
}

// Get the sticky class
$sticky_class = esc_attr(apply_filters('edubin_get_widget_sticky_class', 'no-sticky'));

// Render the sidebar only if it's active
if (is_active_sidebar('woocommerce_shop_page_sidebar')) {
    echo '<aside id="secondary" class="widget-area tpc-sidebar-widget ' . esc_attr($edubin_wc_sidebar_clm) . '">';
        echo '<div class="widget-area-wrapper ' . $sticky_class . '">';
            dynamic_sidebar('woocommerce_shop_page_sidebar');
        echo '</div>';
    echo '</aside>';
}