<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 10.1.2
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

$edubin_wc_sidebar = Edubin::setting( 'edubin_wc_sidebar' );
$woo_sidebar_width = Edubin::setting( 'woo_sidebar_width' );

if ($edubin_wc_sidebar == 'sidebarnone') {
	$edubin_wc_sidebar_clm = 'edubin-col-lg-12' ;
}
elseif ($woo_sidebar_width == 'sidebar_big') {
	$edubin_wc_sidebar_clm = 'edubin-col-lg-8' ;
}
elseif($woo_sidebar_width == 'sidebar_small'){
	$edubin_wc_sidebar_clm = 'edubin-col-lg-9' ;
}


echo '<div class="tpc-site-content-inner' . esc_attr( apply_filters( 'edubin_container_class', ' edubin-container' ) ) . '">';
	do_action( 'edubin_before_content' );

	if (is_active_sidebar( 'woocommerce_shop_page_sidebar' )) {

		echo '<div class="edubin-row">';

		if ( 'sidebarleft' == $edubin_wc_sidebar ) :
			get_template_part( 'woocommerce/tpl-part/sidebar'); 
		endif;

		echo '<div class="' . esc_attr( $edubin_wc_sidebar_clm ) . '">';
	}

	/**
	 * Hook: woocommerce_before_main_content.
	 *
	 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
	 * @hooked woocommerce_breadcrumb - 20
	 * @hooked WC_Structured_Data::generate_website_data() - 30
	 */
	//do_action( 'woocommerce_before_main_content' );

	if ( woocommerce_product_loop() ) {

		/**
		 * Hook: woocommerce_before_shop_loop.
		 *
		 * @hooked woocommerce_output_all_notices - 10
		 * @hooked woocommerce_result_count - 20
		 * @hooked woocommerce_catalog_ordering - 30
		 */
		do_action( 'woocommerce_before_shop_loop' );


		woocommerce_product_loop_start();

		if ( wc_get_loop_prop( 'total' ) ) {
			while ( have_posts() ) {
				the_post();

				/**
				 * Hook: woocommerce_shop_loop.
				 */
				do_action( 'woocommerce_shop_loop' );

				wc_get_template_part( 'content', 'product' );
			}
		}

		woocommerce_product_loop_end();

		/**
		 * Hook: woocommerce_after_shop_loop.
		 *
		 * @hooked woocommerce_pagination - 10
		 */
		do_action( 'woocommerce_after_shop_loop' );
	} else {
		/**
		 * Hook: woocommerce_no_products_found.
		 *
		 * @hooked wc_no_products_found - 10
		 */
		do_action( 'woocommerce_no_products_found' );
	}

	/**
	 * Hook: woocommerce_after_main_content.
	 *
	 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
	 */
	//do_action( 'woocommerce_after_main_content' );

	echo '</div>';

	if (is_active_sidebar( 'woocommerce_shop_page_sidebar' )) {

		if ( 'alignright' == $edubin_wc_sidebar ) :
 			get_template_part( 'woocommerce/tpl-part/sidebar'); 
		endif;

		echo '</div>';
		echo '</div>';
	}

	do_action( 'edubin_after_content' );
echo '</div>';

get_footer( 'shop' );
