<?php
if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

$edubin_post_thumb_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'edubin-post-thumb' );
$content_class = 'content position-top';
if ( isset( $edubin_post_thumb_src ) && ! empty( $edubin_post_thumb_src ) ) :
    $edubin_post_thumb_url = $edubin_post_thumb_src[0];
else :
    $edubin_post_thumb_url = '';
	$content_class = $content_class . ' ' . 'without-thumb';
endif;

$blog_comment_short_text  = Edubin::setting( 'blog_comment_short_text' );

$blog_post_desktop_cols  = 12/Edubin::setting( 'blog_post_columns' );

if ( isset( $_GET['column'] ) && $_GET['column'] == 3 ) :
	$blog_post_desktop_cols = 4;
endif;

$excerpt_length = Edubin::setting( 'blog_excerpt_length' );
if ( isset( $_GET['excerpt_length'] ) ) :
	$excerpt_length = (int)$_GET['excerpt_length'] ? $_GET['excerpt_length'] : $excerpt_length;
endif;

$masonry_status = Edubin::setting( 'blog_masonry_show' );
if ( $masonry_status || isset( $_GET['masonry'] ) ) :
	$blog_post_desktop_cols = $blog_post_desktop_cols . ' ' . 'tpc-masonry-item';
endif;

$blog_comments_text = Edubin::setting( 'blog_comments_text' ) ?: esc_html__('Comments', 'edubin');
$blog_author_show = Edubin::setting( 'blog_author_show' ) ?: false;
$blog_date_show = Edubin::setting( 'blog_date_show' )  ?: false;
$blog_comment_show = Edubin::setting( 'blog_comment_show' )  ?: false;
$blog_category_show = Edubin::setting( 'blog_category_show' ) ?: false;
$blog_read_more_btn_show = Edubin::setting( 'blog_read_more_btn_show' );
$blog_button_text = Edubin::setting( 'blog_button_text' ) ?: esc_html__('Read More', 'edubin');

?>
<div id="post-<?php the_ID(); ?>" <?php post_class( 'edubin-post-one-single-grid edubin-col-lg-' . esc_attr( $blog_post_desktop_cols ) . ' edubin-col-md-6 edubin-col-sm-12' ); ?> data-sal>

	<?php
	echo '<div class="edu-blog blog-style-2">';
		echo '<div class="inner">';

			if ( $edubin_post_thumb_url ) :
				echo '<div class="thumbnail">';
					echo '<a href="' . esc_url( get_the_permalink() ) . '">';
						echo '<img src="' . esc_url( $edubin_post_thumb_url ). '" alt="' . esc_attr( edubin_thumbanil_alt_text( get_post_thumbnail_id( get_the_id() ) ) ). '" >';
					echo '</a>';
				echo '</div>';
			endif;

			echo '<div class="' . esc_attr( $content_class ) . '">';
			
                echo '<ul class="blog-meta">';

                    if ( 'post' === get_post_type() && $blog_author_show ): edubin_posted_author(); endif;

                    if ( $blog_category_show && edubin_category_by_id( get_the_ID())) {
                        echo '<li class="meta-blog-cat">';
                            echo '<i class="flaticon-folder"></i>';
                            echo wp_kses_post( edubin_category_by_id( get_the_ID(), 'category' ) );
                        echo '</li>';
                    }

                    if ( $blog_date_show ) {
                        echo '<li>';
                            echo '<i class="flaticon-calendar"></i>';
                            echo esc_html( get_the_date() );
                        echo '</li>';
                    }
                    if ( $blog_comment_show ) {
                        echo '<li>';
                            echo '<i class="flaticon-chat"></i>';
                            printf( // WPCS: XSS OK.
                                /* translators: 1: comment count number, 2: title. */
                                esc_html( _nx( '%1$s %2$s', '%1$s %2$s', get_comments_number(), 'comments title', 'edubin' ) ),
                                number_format_i18n( get_comments_number() ),
                                esc_html( $blog_comments_text ),
                                '<span>' . esc_html( get_the_title() ) . '</span>'
                            );
                        echo '</li>';
                    }

                echo '</ul>';

			echo edubin_get_title( 'h4' );

			echo '</div>';
		echo '</div>';
	echo '</div>';
echo '</div>';