<?php
if ( ! defined( 'ABSPATH' ) ) exit; 

echo '<div class="edubin-course layout-' . esc_attr( $args['style'] ) . '">';
    echo '<div class="course__container">';
        echo '<div class="course__media">';

            echo '<a class="course-thumb" href="' . esc_url( get_the_permalink() ) . '">';
                echo '<img class="w-100" src="' . esc_url( $args['thumb_url'] ) . '" alt="' . esc_attr( edubin_thumbanil_alt_text( get_post_thumbnail_id( get_the_id() ) ) ). '">';
            echo '</a>';

            echo '<div class="course__meta-top">';

                if ( $args['show_cat_list']  && !empty( get_the_term_list(get_the_ID(), 'course_cat') )) {
                    echo '<div class="course__categories">';
                        echo get_the_term_list(get_the_ID(), 'course_cat');
                    echo '</div>';
                }
                if ( $args['show_wishlist_list'] ) {
                     Edubin_Wishlist::content( $post );
                }
            echo '</div>';


        echo '</div>';

        echo '<div class="course__content">';

            if ( $args['show_price'] ) {
                echo '<div class="price__1">';
                   echo wp_kses_post( Edubin_LIF_LMS_Helper::course_price() );
                echo '</div>';
            }

            if ( $args['show_title'] ) {
                echo edubin_get_title();
            }

            // if ( function_exists( 'lifcr_course_rating' ) && $args['show_review_list'] ) :
            //     echo '<div class="edubin-course-rate">';
            //         lifcr_course_rating_stars();
            //     echo '</div>';
            // endif;

            if ( $args['show_excerpt_list'] ) :
                echo '<div class="course-excerpt course-excerpt-list">';
                    echo wpautop( wp_trim_words( wp_kses_post( get_the_excerpt() ), esc_html( $args['excerpt_length'] ), esc_html( $args['excerpt_end'] ) ) );
                echo '</div>';
            endif;

         echo '<div class="course__content--meta">';

                if ( $args['show_lessons_list'] ) {
                    echo '<div class="course__meta-left">';

                        $course = new \LLMS_Course( $post );

                        $students = $course->get_student_count();
                        $students_text = esc_html__(' Enrolled', 'edubin');

                        if ( $args['show_enrolled']) {
                            echo '<span class="course-lessons"><i class="flaticon-study"></i>';
                                 echo '<span class="value">';
                                        echo esc_attr($students);
                                        if ($args['show_enrolled_text']) {
                                            echo esc_html($students_text); 
                                        }
                                 echo '</span>';
                            echo '</span>';
                        }

                        $lessons = $course->get_lessons_count();
                        $lessons = $lessons ? $lessons : 0; // Ensure $lessons is an integer
                        $lessons_text = ($lessons == 1) ? esc_html__(' Lesson', 'edubin') : esc_html__(' Lessons', 'edubin');

                        if ( $args['show_lessons']) {
                            echo '<span class="course-lessons"><i class="flaticon-book"></i>';
                                 echo '<span class="value">';

                                    echo esc_attr($lessons);

                                    if ( $args['show_lessons_text'] ) {
                                        echo esc_html($lessons_text);
                                    }
                                 echo '</span>';
                            echo '</span>';
                        }

                    echo '</div>';
                }
           echo '</div>';

        echo '</div>';
    echo '</div>';


echo '</div>';
