<?php

defined('ABSPATH') || exit;

function edubin_scripts() {

    $sticky_header = Edubin::setting( 'sticky_header_enable' );

    wp_enqueue_style( 'edubin-style', get_stylesheet_uri() );

    wp_enqueue_style( 'edubin-flaticon', get_template_directory_uri() . '/assets/fonts/flaticon_edubin.css', array(), EDUBIN_THEME_VERSION );

    if ( Edubin::setting( 'metismenu_css' ) ) :
        wp_enqueue_style( 'metismenu', get_template_directory_uri() . '/assets/css/metisMenu.min.css', array(), EDUBIN_THEME_VERSION );
    endif;

    if ( Edubin::setting( 'nice_select_css' ) ) :
        wp_enqueue_style( 'nice-select', get_template_directory_uri() . '/assets/css/nice-select.css', array(), EDUBIN_THEME_VERSION );
    endif;
    
    if ( Edubin::setting( 'fancybox_css' ) ) :
       wp_register_style( 'jquery-fancybox', get_template_directory_uri() . '/assets/css/jquery.fancybox.min.css', array(), EDUBIN_THEME_VERSION );
    endif;

    if ( Edubin::setting( 'tipped_css' ) ) :
        wp_enqueue_style( 'edubin-tipped', get_template_directory_uri() . '/assets/css/tipped.min.css', array(), EDUBIN_THEME_VERSION );
    endif;

    if ( Edubin::setting( 'preloader_show' ) ) :
        wp_enqueue_style( 'edubin-preloader', get_template_directory_uri() . '/assets/css/preloader.css', array(), EDUBIN_THEME_VERSION );
    endif;

     if ( is_404() ) {
        wp_enqueue_style( 'edubin-404-page', get_template_directory_uri() . '/assets/css/404-page.css', array(), EDUBIN_THEME_VERSION );
    }

    if ( is_home() || is_archive() || is_category() || is_tag() || is_author() || is_date() || is_search() ) {
        wp_enqueue_style( 'edubin-post', get_template_directory_uri() . '/assets/css/post.css', array(), EDUBIN_THEME_VERSION );
    }

    if ( is_singular( 'post' ) ) {
        wp_enqueue_style( 'edubin-post-single', get_template_directory_uri() . '/assets/css/post-single.css', array(), EDUBIN_THEME_VERSION );
    }

    if ( is_singular() && ( comments_open() || get_comments_number() ) ) {
        wp_enqueue_style( 'edubin-comments', get_template_directory_uri() . '/assets/css/comments.css', array(), EDUBIN_THEME_VERSION );
    }

    $header = apply_filters( 'edubin_get_header_layout',  Edubin::setting( 'edubin_get_elementor_header' ) ) ?: 'theme-default-header';

   // if ( $header === 'theme-default-header' ) {
        wp_enqueue_style( 'edubin-header', get_template_directory_uri() . '/assets/css/header.css', array(), EDUBIN_THEME_VERSION );
  //  }

    wp_enqueue_style( 'edubin-page-title', get_template_directory_uri() . '/assets/css/page-title.css', array(), EDUBIN_THEME_VERSION );

    $footer = apply_filters( 'edubin_get_footer_layout',  Edubin::setting( 'edubin_get_elementor_footer' ) ) ?: 'theme-default-footer';

    if ( $footer === 'theme-default-footer' ) {
        wp_enqueue_style( 'edubin-footer', get_template_directory_uri() . '/assets/css/footer.css', array(), EDUBIN_THEME_VERSION );
    }

    if ( Edubin::setting( 'top_search_enable' ) ) {
        wp_enqueue_style( 'edubin-search', get_template_directory_uri() . '/assets/css/search.css', array(), EDUBIN_THEME_VERSION );
    }

    if ( Edubin::setting( 'login_reg_show' ) ) {
        wp_enqueue_style( 'edubin-login-popup', get_template_directory_uri() . '/assets/css/login-popup.css', array(), EDUBIN_THEME_VERSION );
    }

    // Third Party Plugin CSS
    if (class_exists('LearnPress')){
        $get_lp_plugin_dir        = WP_PLUGIN_DIR . '/learnpress/learnpress.php';
        $lp_plugin_version_number = get_plugin_data($get_lp_plugin_dir);

        if ( $lp_plugin_version_number['Version'] < '4.0.0'):
            wp_enqueue_style('edubin-learnpress', EDUBIN_URI . 'assets/css/learnpress.css', array(), EDUBIN_THEME_VERSION);
        endif;

        if ( $lp_plugin_version_number['Version'] > '4.0.0'):
            wp_enqueue_style('edubin-learnpress-v4', EDUBIN_URI . 'assets/css/learnpress-v4.css', array(), EDUBIN_THEME_VERSION);
        endif;
    }

    if (function_exists('tutor')):
        wp_enqueue_style('edubin-tutor', EDUBIN_URI . 'assets/css/tutor.css', array(), EDUBIN_THEME_VERSION);
    endif;

    if ( class_exists('MasterStudy\Lms\Plugin')):
        wp_enqueue_style('edubin-masterstudy', EDUBIN_URI . 'assets/css/masterstudy.css', array(), EDUBIN_THEME_VERSION);
    endif;

    if ( class_exists('LifterLMS')):
        wp_enqueue_style('edubin-lifter', EDUBIN_URI . 'assets/css/lifter.css', array(), EDUBIN_THEME_VERSION);
    endif;

   if ( class_exists('Zoom_Video_Conferencing_Api') ) :
        wp_enqueue_style( 'edubin-zoom', get_template_directory_uri() . '/assets/css/zoom.css', array(), EDUBIN_THEME_VERSION );
   endif;

    if ( class_exists( 'WPEMS' ) || class_exists('Tribe__Events__Main') ) :
        wp_enqueue_style( 'edubin-wpem', get_template_directory_uri() . '/assets/css/wpem.css', array(), EDUBIN_THEME_VERSION );
    endif;

    if ( class_exists( 'WPEMS' ) && is_singular( 'tp_event' ) || class_exists( 'Tribe__Events__Main' ) && is_singular( 'tribe_events' ) ){
            wp_enqueue_style( 'edubin-team', get_template_directory_uri() . '/assets/css/team.css', array(), EDUBIN_THEME_VERSION );
    }

    if (class_exists('Tribe__Events__Filterbar__PUE')):
        wp_enqueue_style('edubin-events-filterbar', EDUBIN_URI . 'assets/css/filterbar.css', array(), EDUBIN_THEME_VERSION);
    endif;

    wp_enqueue_style( 'edubin-main', get_template_directory_uri() . '/assets/css/main.css', array(), EDUBIN_THEME_VERSION );

   // Global Courses CSS 
    if (class_exists('SFWD_LMS') || class_exists('LearnPress') || class_exists('Sensei_Main') || function_exists('tutor') || class_exists('MasterStudy\Lms\Plugin') ||class_exists('LifterLMS')) {
        wp_enqueue_style('global-courses', EDUBIN_URI . 'assets/css/global-courses.css', array(), EDUBIN_THEME_VERSION);
        
        // Course Filter Reset
        wp_register_script( 'edubin-filter-reset', get_template_directory_uri() . '/assets/js/filter-reset.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    }

    if ( Edubin::setting( 'mouse_move_animation_js' ) ) {
        wp_enqueue_script( 'edubin-mouse-animation', get_template_directory_uri() . '/assets/js/edubin-mouse-move-animation.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    }

    wp_enqueue_script( 'edubin-sal-js', get_template_directory_uri() . '/assets/js/sal.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    wp_enqueue_script( 'edubin-navigation', get_template_directory_uri() . '/assets/js/navigation.js', array(), EDUBIN_THEME_VERSION, true );
  
     if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) :
        wp_enqueue_script( 'comment-reply' );
    endif;

    if ( Edubin::setting( 'back_to_top_show' ) ?: true ) :
        wp_enqueue_script( 'edubin-back-to-top', get_template_directory_uri() . '/assets/js/back-to-top.js', array(), EDUBIN_THEME_VERSION, true );
    endif;

    if ( Edubin::setting( 'smooth_scroll_js' ) ) :
        wp_enqueue_script( 'edubin-smooth-scroll', get_template_directory_uri() . '/assets/js/smooth-scroll.min.js', array(), EDUBIN_THEME_VERSION, true );
    endif;

    if ( Edubin::setting( 'metismenu_js' ) ) :
         wp_enqueue_script( 'metismenu', get_template_directory_uri() . '/assets/js/metisMenu.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    endif;

   if ( Edubin::setting( 'theia_sticky_sidebar_js' ) ) :
        wp_register_script( 'theia-sticky-sidebar', get_template_directory_uri() . '/assets/js/theia-sticky-sidebar.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    endif;

   if ( Edubin::setting( 'skip_link_focus_fix_js' ) ) :
        wp_enqueue_script( 'edubin-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.js', array(), EDUBIN_THEME_VERSION, true );
    endif;

   if ( Edubin::setting( 'tipped_js' ) ) :
        wp_enqueue_script( 'edubin-tipped', get_template_directory_uri() . '/assets/js/tipped.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    endif;

   if ( Edubin::setting( 'fancybox_js' ) ) :
         wp_register_script( 'jquery-fancybox', get_template_directory_uri() . '/assets/js/jquery.fancybox.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    endif;

   if ( Edubin::setting( 'nice_select_js' ) ) :
          wp_enqueue_script( 'nice-select', get_template_directory_uri() . '/assets/js/nice-select.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    endif;

    wp_enqueue_script( 'youtube-popup', get_template_directory_uri() . '/assets/js/youtube-popup.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
    
  //  if ( Edubin::setting( 'sticky_header_enable' ) ) {
        wp_enqueue_script( 'headroom', get_template_directory_uri() . '/assets/js/headroom.min.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );
  //  }
    wp_enqueue_script( 'edubin-init', get_template_directory_uri() . '/assets/js/init.js', array( 'jquery' ), EDUBIN_THEME_VERSION, true );

    // Like for blog single page
    if (Edubin::setting( 'blog_single_like_show' ) && is_single()) {
        wp_localize_script('edubin-init', 'edubin_like_ajax', ['ajaxurl' => admin_url('admin-ajax.php')]);
    }
    if ( ! empty( $GLOBALS['edubin_has_social_share'] ) && $GLOBALS['edubin_has_social_share'] === true ) {
         wp_enqueue_style( 'edubin-social-share', get_template_directory_uri() . '/assets/css/social-share.css', array(), EDUBIN_THEME_VERSION );
    }

   // Sticky Mode: edubin_sticky_type or scroll_up
    $sticky_mode = Edubin::setting( 'edubin_sticky_type' ) ?: 'smart'; // default 'smart'
    wp_localize_script('edubin-init', 'edubin_sticky_data', array(
        'mode' => esc_js($sticky_mode),
    ));
    
    // Cart Animation and Tutor native cart
    wp_localize_script( 'edubin-init', 'edubin_cart', [
        'ajax'     => admin_url( 'admin-ajax.php' ),
        'nonce'    => wp_create_nonce( 'tutor_nonce' ),
        'animate'  => Edubin::setting( 'cart_animation' ) ? true : false,
    ]);


}
add_action( 'wp_enqueue_scripts', 'edubin_scripts' );


/**
 * Register/Enqueue JS/CSS In Admin Panel
 */
function edubin_register_admin_styles()
{
    wp_enqueue_script('edubin-unloack', EDUBIN_URI . '/admin/assets/js/edubin-unloack.js', array('jquery'), '1.0.0');

    wp_enqueue_style('edubin-admin-css', EDUBIN_URI . '/admin/assets/css/admin.css', array(), EDUBIN_THEME_VERSION);

}
add_action('admin_enqueue_scripts', 'edubin_register_admin_styles');    
