<?php

defined('ABSPATH') || exit;

// Deprecated function lists
function edubin_tribe_events_widgets_init() {}
function edubin_woocommerce_widgets_init() {}


///Theme settings style root
function edubin_get_url_override_allowlist() {
    return [
        'blog_single_layout'       => ['blog_layout_image_first', 'blog_layout_title_first', 'blog_layout_overlay'],
        'tutor_single_page_layout' => ['1', '2', '3', '4', '5'],
        'lp_single_page_layout'    => ['1', '2', '3', '4', '5'],
        'ld_single_page_layout'    => ['1', '2', '3', '4', '5'],
        'ms_single_page_layout'    => ['1', '2', '3', '4', '5'],
        'sen_course_archive_style' => ['1', '2', '3', '4', '5'],
        'lif_single_page_layout'   => ['1', '2', '3', '4', '5'],
        'rtl_single_page_layout'   => ['1', '2', '3', '4', '5'],
    ];
}

add_action('after_setup_theme', function () {
    $allowlist = edubin_get_url_override_allowlist();

    foreach ($allowlist as $setting => $allowed_values) {
        // Each theme_mod_{setting} for separate filter
        add_filter("theme_mod_{$setting}", function ($value) use ($setting, $allowed_values) {
            if (isset($_GET[$setting])) {
                $new = sanitize_text_field(wp_unslash($_GET[$setting]));
                if (in_array($new, $allowed_values, true)) {
                    return $new;
                }
            }
            return $value;
        }, 10, 1);
    }
});

