<?php
/*----------------------------
LifterLMS Archive Page
----------------------------*/
 Kirki::add_section( 'edubin_lif_archive_page_section', array(
    'title'    =>  esc_html__( 'Course Archive Page', 'edubin' ),
    'panel' =>  'edubin_lif_panel'
) );

// Custom Page archive title
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'text',
    'settings'    => 'lif_archive_page_title',
    'label'       => esc_html__( 'Custom Archive Page Title', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => esc_html__('Courses', 'edubin'),
    'transport'   => 'refresh',
] );

// Enable pagination
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_course_archive_style',
    'label'       => esc_html__( 'Course Style', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
    'multiple'    => false,
    'choices'     => [
        '1' => esc_html__('Style 01', 'edubin'),
        '2' => esc_html__('Style 02', 'edubin'),
        '3' => esc_html__('Style 03', 'edubin'),
        '4' => esc_html__('Style 04', 'edubin'),
        '5' => esc_html__('Style 05', 'edubin'),
        '6' => esc_html__('Style 06', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_course_masonry_layout',
    'label'       => esc_html__( 'Masonry Layout?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '0',
] );

// Media?
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_archive_media_show',
    'label'       => esc_html__( 'Media?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_intor_video',
    'label'       => esc_html__( 'PopUp Intro Video?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => false,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_archive_image_size',
    'label'       => esc_html__( 'Select Image Size', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => 'edubin-post-thumb',
    'multiple'    => false,
    'placeholder' => esc_html__( 'Select a image size', 'edubin' ),
    'choices'     => edubin_get_thumbnail_sizes(),
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'custom',
    'settings'    => 'divider_lif_header_top',
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '<hr>',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_archive_title_show',
    'label'       => esc_html__( 'Course Title?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => true,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_excerpt_show',
    'label'       => esc_html__( 'Excerpt?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => false,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'slider',
    'settings'    => 'lif_course_excerpt_length',
    'label'       => esc_html__( 'Excerpt Length', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => 25,
    'choices'     => [
        'min'  => 1,
        'max'  => 250,
        'step' => 1,
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_excerpt_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_price_show',
    'label'       => esc_html__( 'Price?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_lesson_show',
    'label'       => esc_html__( 'Lessons?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_lesson_text_show',
    'label'       => esc_html__( 'Lessons Text?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_lesson_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_enroll_show',
    'label'       => esc_html__( 'Enrolled Students?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => true,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_enroll_text_show',
    'label'       => esc_html__( 'Enrolled Students Text?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_enroll_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

// Kirki::add_field( 'edubin_theme_config', [
//     'type'        => 'toggle',
//     'settings'    => 'lif_quiz_show',
//     'label'       => esc_html__( 'Quiz?', 'edubin' ),
//     'section'     => 'edubin_lif_archive_page_section',
//     'default'     => false,
// ] );

// Kirki::add_field( 'edubin_theme_config', [
//     'type'        => 'toggle',
//     'settings'    => 'lif_quiz_text_show',
//     'label'       => esc_html__( 'Quiz Text?', 'edubin' ),
//     'section'     => 'edubin_lif_archive_page_section',
//     'default'     => '1',
//     'active_callback'   =>  [
//         [
//             'setting'   =>  'lif_quiz_show',
//             'operator'  =>  '===',
//             'value'     =>  true,
//         ],
//     ],
// ] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_cat_show',
    'label'       => esc_html__( 'Categories?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_wishlist_show',
    'label'       => esc_html__( 'Wishlist?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

// Kirki::add_field( 'edubin_theme_config', [
//     'type'        => 'toggle',
//     'settings'    => 'lif_review_show',
//     'label'       => esc_html__( 'Review?', 'edubin' ),
//     'section'     => 'edubin_lif_archive_page_section',
//     'default'     => '1',
// ] );

// Kirki::add_field( 'edubin_theme_config', [
//     'type'        => 'toggle',
//     'settings'    => 'lif_review_text_show',
//     'label'       => esc_html__( 'Review Text?', 'edubin' ),
//     'section'     => 'edubin_lif_archive_page_section',
//     'default'     => false,
// ] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_level_show',
    'label'       => esc_html__( 'Course Level?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => false,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_instructor_img_on_off',
    'label'       => esc_html__( 'Instructor Avatar?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_instructor_name_on_off',
    'label'       => esc_html__( 'Instructor Name?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'custom',
    'settings'    => 'divider_see_more_btn',
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '<hr>',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_see_more_btn',
    'label'       => esc_html__( 'See More Button?', 'edubin' ),
    'section'     => 'edubin_lif_archive_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', array(
    'label' =>  esc_html__( 'See More - Custom Text', 'edubin' ),
    'type' =>  'text',
    'settings' =>  'lif_see_more_btn_text',
    'section' =>  'edubin_lif_archive_page_section',
    'default'     => '',
    'transport' =>  'refresh',
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_see_more_btn',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
) );

/*----------------------------
LifterLMS Single Page
----------------------------*/
 Kirki::add_section( 'edubin_lif_single_page_section', array(
    'title'    =>  esc_html__( 'Course Single Page', 'edubin' ),
    'panel' =>  'edubin_lif_panel'
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_single_page_layout',
    'label'       => esc_html__( 'Page Style', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
    'multiple'    => false,
    'choices'     => [
        '1' => esc_html__('Style 01', 'edubin'),
        '2' => esc_html__('Style 02', 'edubin'),
        '3' => esc_html__('Style 03', 'edubin'),
        '4' => esc_html__('Style 04', 'edubin'),
        '5' => esc_html__('Style 05', 'edubin'),
        // '6' => esc_html__('Style 06', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_course_header_style',
    'label'       => esc_html__( 'Header Style', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
    'multiple'    => false,
    'choices'     => [
        '1' => esc_html__('Style 01', 'edubin'),
        '2' => esc_html__('Style 02', 'edubin'),
    ],
    
    'active_callback' => array(
        array(
            array(
                'setting'  => 'lif_single_page_layout',
                'operator' => '==',
                'value'    => '1',
            ),
            // OR
            array(
                array(
                    'setting'  => 'lif_single_page_layout',
                    'operator' => '==',
                    'value'    => '3',
                ),
            ),
        ),
    ),

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'lif_intro_video_position',
    'label'       => esc_html__( 'Intro Image/Video Preview', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => 'intro_video_sidebar',
    'multiple'    => false,
    'choices'     => [
        'none' => esc_html__('Off', 'edubin'),
        'intro_video_content' => esc_html__('Content Area', 'edubin'),
        'intro_video_sidebar' => esc_html__('Sidebar Area', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_single_title_tag',
    'label'       => esc_html__( 'Title Tag', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => 'h1',
    'placeholder' => esc_html__( 'Select an tag...', 'edubin' ),
    'multiple'    => false,
    'choices'     => [
        'h1' => esc_html__( 'H1', 'edubin' ),
        'h2' => esc_html__( 'H2', 'edubin' ),
        'h3' => esc_html__( 'H3', 'edubin' ),
        'h4' => esc_html__( 'H4', 'edubin' ),
        'h5' => esc_html__( 'H5', 'edubin' ),
        'h6' => esc_html__( 'H6', 'edubin' ),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_breadcrumb',
    'label'       => esc_html__( 'Breadcrumb?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_excerpt',
    'label'       => esc_html__( 'Excerpt?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_course_info',
    'label'       => esc_html__( 'Course Info?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_instructor_single',
    'label'       => esc_html__( 'Instructor?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_enroll',
    'label'       => esc_html__( 'Enrolled?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_lesson',
    'label'       => esc_html__( 'Lessons?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_duration',
    'label'       => esc_html__( 'Duration?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => false,
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_cat',
    'label'       => esc_html__( 'Category?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_language',
    'label'       => esc_html__( 'Language?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_certificate',
    'label'       => esc_html__( 'Certificate?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => false,
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_social_shear',
    'label'       => esc_html__( 'Social Share?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'custom',
    'settings'    => 'divider_lif_single_cat',
    'section'     => 'edubin_lif_single_page_section',
    'default'     => '<hr>',
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_sidebar_sticky',
    'label'       => esc_html__( 'Sidebar Sticky?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => false,
] );
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'lif_single_cat_sidebar',
    'label'       => esc_html__( 'Sidebar Category List?', 'edubin' ),
    'section'     => 'edubin_lif_single_page_section',
    'default'     => false,
] );

/*----------------------------
LifterLMS Related Courses
----------------------------*/
 Kirki::add_section( 'edubin_lif_related_course_section', array(
    'title'    =>  esc_html__( 'Related Courses', 'edubin' ),
    'panel' =>  'edubin_lif_panel'
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'lif_related_course_position',
    'label'       => esc_html__( 'Related Course Preview', 'edubin' ),
    'section'     => 'edubin_lif_related_course_section',
    'default'     => 'content',
    'multiple'    => false,
    'choices'     => [
        'none' => esc_html__('Off', 'edubin'),
        'sidebar' => esc_html__('Sidebar Area', 'edubin'),
        'content' => esc_html__('Content Area', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'lif_related_course_style',
    'label'       => esc_html__( 'Related Course Style', 'edubin' ),
    'section'     => 'edubin_lif_related_course_section',
    'default'     => 'square',
    'choices'     => [
        'round' => esc_html__('Round', 'edubin'),
        'square' => esc_html__('Square', 'edubin'),
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_related_course_position',
            'operator'  =>  '===',
            'value'     =>  'sidebar',
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', array(
    'label' =>  esc_html__( 'Custom Heading', 'edubin' ),
    'type' =>  'text',
    'settings' =>  'lif_related_course_title',
    'section' =>  'edubin_lif_related_course_section',
    'default'   => 'Related Courses',
    'transport' =>  'postMessage',
    'active_callback'   =>  [
        [
            'setting'   =>  'lif_course_feature_cat_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'lif_related_course_by',
    'label'       => esc_html__( 'Related Course Query By', 'edubin' ),
    'section'     => 'edubin_lif_related_course_section',
    'default'     => 'tags',
    'choices'     => [
        'category' => esc_html__('Category', 'edubin'),
        'tags' => esc_html__('Tags', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'number',
    'settings'    => 'lif_related_course_items',
    'label'       => esc_html__( 'Number of Courses', 'edubin' ),
    'section'     => 'edubin_lif_related_course_section',
    'default'     => 3,
    'choices'     => [
        'min'  => 1,
        'step' => 1,
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'lif_related_course_columns',
    'label'       => esc_html__( 'Related Course Columns', 'edubin' ),
    'section'     => 'edubin_lif_related_course_section',
    'default'     => '4',
    'choices'     => [
        '3' => __('4 Columns', 'edubin'),
        '4' => __('3 Columns', 'edubin'),
        '6' => __('2 Columns', 'edubin'),
    ],
] );




