<?php

global $wp_registered_sidebars;
$sidebars = array();
if ( ! empty( $wp_registered_sidebars ) ) :
    foreach ( $wp_registered_sidebars as $sidebar ) :
        $sidebars[$sidebar['id']] = $sidebar['name'];
    endforeach;
endif;

/*----------------------------
Blog page
----------------------------*/
 Kirki::add_section( 'edubin_blog_page_section', array(
    'title'    =>  esc_html__( 'Blog Page', 'edubin' ),
    'panel'          => 'header_blog_panel',
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_post_style',
    'label'       => esc_html__( 'Blog Style', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => 'standard',
    'choices'     => [
        'standard'   => esc_html__( 'Standard', 'edubin' ),
        '1'   => esc_html__( 'Style 01', 'edubin' ),
        '2'   => esc_html__( 'Style 02', 'edubin' ),
        '3'   => esc_html__( 'Style 03', 'edubin' ),
    ],

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'blog_post_columns',
    'label'       => esc_html__( 'Blog Columns', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '2',
    'choices'     => [
        '1' => esc_html__('1', 'edubin'),
        '2' => esc_html__('2', 'edubin'),
        '3' => esc_html__('3', 'edubin'),
        '4' => esc_html__('4', 'edubin'),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_archive_sidebar_name',
    'label'       => esc_html__( 'Select Sidebar', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => 'sidebar-1',
    'choices'     => $sidebars

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'blog_sidebar',
    'label'       => esc_html__( 'Sidebar', 'edubin' ),
    'description' => esc_html__( 'Select your sidebar position', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => 'right-sidebar',
    'choices'     => [
        'left-sidebar'   => esc_html__( 'Left', 'edubin' ),
        'no-sidebar'   => esc_html__( 'No Sidebar', 'edubin' ),
        'right-sidebar'   => esc_html__( 'Right', 'edubin' ),
    ],
 ] );
    
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_sidebar_width',
    'label'       => esc_html__( 'Sidebar Width', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '3',
    'choices'     => [
        '3' => esc_html__('25%', 'edubin'),
        '4' => esc_html__('33%', 'edubin'),
    ],

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_excerpt_show',
    'label'       => esc_html__( 'Excerpt?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => true,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'number',
    'settings'    => 'blog_excerpt_length',
    'label'       => esc_html__( 'Excerpt Length', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'  => 18,
        'choices'  => [
            'min'       => -1,
            'step'      => 1,
            'max'       => 250
        ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'custom',
    'settings'    => 'divider_before_blog_sidebar_sticky',
    'section'     => 'edubin_blog_page_section',
    'default'     => '<hr>',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_masonry_show',
    'label'       => esc_html__( 'Masonry Layout?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => false,
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_sidebar_sticky',
    'label'       => esc_html__( 'Sidebar Sticky?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_author_show',
    'label'       => esc_html__( 'Author?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '0',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_date_show',
    'label'       => esc_html__( 'Date?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_category_show',
    'label'       => esc_html__( 'Category', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '1',
] );

// Post View
// Kirki::add_field( 'edubin_theme_config', [
//     'type'        => 'toggle',
//     'settings'    => 'blog_view_show',
//     'label'       => esc_html__( 'Post View', 'edubin' ),
//     'section'     => 'edubin_blog_page_section',
//     'default'     => '0',
// ] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_read_more_btn_show',
    'label'       => esc_html__( 'Read More Button?', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_read_more_btn_style',
    'label'       => esc_html__( 'Button Style', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '1',
    'choices'     => [
        '1'   => esc_html__( 'Style 01', 'edubin' ),
        '2'   => esc_html__( 'Style 02', 'edubin' ),
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_read_more_btn_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ]
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'text',
    'label'       => esc_html__('Custom - Read More', 'edubin'),
    'settings'    => 'blog_button_text',
    'section'     => 'edubin_blog_page_section',
    'default'     => esc_html('Read More'),
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_read_more_btn_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ]
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_comment_show',
    'label'       => esc_html__( 'Comment', 'edubin' ),
    'section'     => 'edubin_blog_page_section',
    'default'     => '0',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'text',
    'label'       => esc_html__('Custom - Comments', 'edubin'),
    'settings'    => 'blog_comments_text',
    'section'     => 'edubin_blog_page_section',
    'default'     => esc_html('Comments'),
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'text',
    'label'       => esc_html__('Custom - Comment', 'edubin'),
    'settings'    => 'blog_comment_short_text',
    'section'     => 'edubin_blog_page_section',
    'default'     => esc_html('Comment'),
] );

/*----------------------------
Single Page
----------------------------*/
 Kirki::add_section( 'edubin_blog_single_section', array(
    'title'    =>  esc_html__( 'Single Page', 'edubin' ),
    'panel'          => 'header_blog_panel',
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_single_layout',
    'label'       => esc_html__( 'Blog Single Style', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => 'blog_layout_overlay',
    'choices'     => [
        'blog_layout_overlay'   => esc_html__( 'Image Overlay', 'edubin' ),
        'blog_layout_title_first'   => esc_html__( 'Title First', 'edubin' ),
        'blog_layout_image_first'   => esc_html__( 'Image First', 'edubin' ),
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'blog_single_page_title_text',
    'label'       => esc_html__( 'Page Title Text', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => 'post-title',
    'choices'     => [
        'post-type-name'   => esc_html__( 'Post Type Name', 'edubin' ),
        'post-title'   => esc_html__( 'Post Title', 'edubin' ),
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_single_layout',
            'operator'  =>  '!==',
            'value'     =>  'blog_layout_overlay',
        ],
    ]
 ] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_single_sidebar_name',
    'label'       => esc_html__( 'Select Sidebar', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => 'sidebar-1',
    'choices'     => $sidebars

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'blog_single_sidebar',
    'label'       => esc_html__( 'Sidebar', 'edubin' ),
    'description' => esc_html__( 'Select your sidebar position', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => 'right-sidebar',
    'choices'     => [
        'left-sidebar'   => esc_html__( 'Left', 'edubin' ),
        'no-sidebar'   => esc_html__( 'No Sidebar', 'edubin' ),
        'right-sidebar'   => esc_html__( 'Right', 'edubin' ),
    ],
 ] );
      
Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'select',
    'settings'    => 'blog_single_sidebar_width',
    'label'       => esc_html__( 'Sidebar Width', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '3',
    'choices'     => [
        '3' => esc_html__('25%', 'edubin'),
        '4' => esc_html__('33%', 'edubin'),
    ],

] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_sidebar_sticky',
    'label'       => esc_html__( 'Sidebar Sticky', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_img_overlay_shape',
    'label'       => esc_html__( 'Image Overlay Shape', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_single_layout',
            'operator'  =>  '===',
            'value'     =>  'blog_layout_overlay',
        ],
    ]
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_author_show',
    'label'       => esc_html__( 'Author', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_author_bio_show',
    'label'       => esc_html__( 'Author Bio', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_date_show',
    'label'       => esc_html__( 'Date', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_category_show',
    'label'       => esc_html__( 'Category', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '0',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_comment_show',
    'label'       => esc_html__( 'Comment', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_like_show',
    'label'       => esc_html__( 'Likes', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_tags_show',
    'label'       => esc_html__( 'Tags', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_single_social_share',
    'label'       => esc_html__( 'Social Share', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_nav_show',
    'label'       => esc_html__( 'Post Navigation', 'edubin' ),
    'section'     => 'edubin_blog_single_section',
    'default'     => '1',
] );

/*----------------------------
Related Post
----------------------------*/
 Kirki::add_section( 'edubin_blog_related_section', array(
    'title'    =>  esc_html__( 'Related Post', 'edubin' ),
    'panel'          => 'header_blog_panel',
) );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'blog_related_show',
    'label'       => esc_html__( 'Related Post', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => '1',
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'text',
    'label'       => esc_html__('Related Posts', 'edubin'),
    'settings'    => 'blog_related_title',
    'section'     => 'edubin_blog_related_section',
    'default'     => esc_html('Related Posts'),
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'number',
    'settings'    => 'related_total_posts',
    'label'       => esc_html__( 'Number of Related Post', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => 3,
    'choices'     => [
        'min'  => 0,
        'max'  => 10,
        'step' => 1,
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'related_post_columns',
    'label'       => esc_html__( 'Related Posts Columns', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => '4',
    'choices'     => [
        '12' => esc_html__('1', 'edubin'),
        '6' => esc_html__('2', 'edubin'),
        '4' => esc_html__('3', 'edubin'),
        '3' => esc_html__('4', 'edubin'),
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'radio-buttonset',
    'settings'    => 'related_posts_by',
    'label'       => esc_html__( 'Related Posts Query By', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => 'tags',
    'choices'     => [
        'category' => esc_html__('Category', 'edubin'),
        'tags' => esc_html__('Tags', 'edubin'),
    ],
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'related_author_show',
    'label'       => esc_html__( 'Author?', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => false,
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'related_date_show',
    'label'       => esc_html__( 'Date?', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => '1',
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

Kirki::add_field( 'edubin_theme_config', [
    'type'        => 'toggle',
    'settings'    => 'related_category_show',
    'label'       => esc_html__( 'Category', 'edubin' ),
    'section'     => 'edubin_blog_related_section',
    'default'     => false,
    'active_callback'   =>  [
        [
            'setting'   =>  'blog_related_show',
            'operator'  =>  '===',
            'value'     =>  true,
        ],
    ],
] );

