(function($) {
    "use strict";
    //===== Preloader
    $(window).on('load', function(event) {
        $('.preloader').delay(500).fadeOut(500);
        $('#preloader_two').fadeOut();
        $(".edubin_image_preloader").fadeOut("slow");
    });
    //===== Header Sticky & Headroom.js
    jQuery(function($) {
        var header = $(".header-get-sticky");
        var topHeader = $(".tpc-header-top-bar");
        var topHeaderHeight = topHeader.length ? topHeader.outerHeight() : 0;
        var topHeaderHidden = false;
        var stickyMode = typeof edubin_sticky_data !== 'undefined' ? edubin_sticky_data.mode : 'smart';
        if (header.length) {
            if (stickyMode === 'always') {
                $(window).on("scroll", function() {
                    var scrollTop = $(this).scrollTop();
                    if (scrollTop > 100) {
                        header.addClass("top-header-removed");
                    } else {
                        header.removeClass("top-header-removed");
                    }
                    if (scrollTop > topHeaderHeight && !topHeaderHidden) {
                        topHeader.slideUp(200);
                        topHeaderHidden = true;
                    } else if (scrollTop === 0 && topHeaderHidden) {
                        topHeader.slideDown(200);
                        topHeaderHidden = false;
                    }
                });
            } else if (stickyMode === 'smart') {
                var options = {
                    offset: {
                        up: 100,
                        down: 200
                    },
                    tolerance: {
                        up: 5,
                        down: 0
                    },
                    classes: {
                        pinned: "headroom--pinned",
                        unpinned: "headroom--unpinned",
                        top: "headroom--top",
                        notTop: "headroom--not-top"
                    }
                };
                var myElement = document.querySelector(".header-get-sticky");
                var headroom = new Headroom(myElement, options);
                headroom.init();
            }
        }
    });
    //===== Login/Register Popup Modal
    $('.tpc-login-register-popup-trigger').on('click', function(e) {
        e.preventDefault();
        $('.edubin-login-form-popup').toggleClass('login-popup-visible');
        $('.edubin-login-popup-overlay').toggleClass('active');
    });
    const login_btn = document.querySelector(".login-item");
    const register_btn = document.querySelector(".register-item");
    $(".register-form").css("display", "none");
    $(function() {
        $('.login-item, #edubin-login-form-trigger').on('click', function() {
            login_btn.classList.add("active");
            $(".register-form").css("display", "none");
            if (register_btn.classList.contains("active")) {
                register_btn.classList.remove("active");
                $(".login-form").removeAttr("style");
            }
        });
        $('.register-item, #edubin-register-form-trigger').on('click', function() {
            register_btn.classList.add("active");
            $(".login-form").css("display", "none");
            if (login_btn.classList.contains("active")) {
                login_btn.classList.remove("active");
                $(".register-form").removeAttr("style");
            }
        });
    });
    //===== Close Login/Register Modal on Click Outside
    $('.edubin-custom-login-wrapper').on('click', function() {
        console.log("clicked");
    });
    //===== Close Login Modal on Close Button Click
    $('.edubin-login-popup-close .close-trigger').on('click', function() {
        $('.edubin-login-form-popup').removeClass('login-popup-visible');
        $('.edubin-login-popup-overlay').removeClass('active');
    });
    //===== Course Filter Auto Select
    $('.edubin-course-filtering input').on('change', function() {
        $('.edubin-course-filtering').submit();
    });
    //===== Course Filter shorting 
    $(document).ready(function() {
        $('.course-orderby').on('change', function() {
            $('.course-top-filter').submit();
        });
    });
    //===== Mobile Menu
    $('.edubin-mobile-hamburger-menu > a').on('click', function(e) {
        e.preventDefault(); // Prevent page scroll
        $(this).toggleClass('edubin-mobile-menu-close--active');
        $(".edubin-mobile-menu-nav-wrapper").toggleClass('edubin-mobile-menu-visible');
        $('body').toggleClass('edubin-mobile-menu-active');
    });
    $('.edubin-mobile-menu-close > a').on('click', function(e) {
        e.preventDefault();
        $('.edubin-mobile-hamburger-menu > a').removeClass('edubin-mobile-menu-close--active');
        $('.edubin-mobile-menu-nav-wrapper').removeClass('edubin-mobile-menu-visible');
        $('body').removeClass('edubin-mobile-menu-active');
    });
    $('.edubin-mobile-menu-overlay').on('click', function(e) {
        e.preventDefault();
        $('.edubin-mobile-hamburger-menu > a').removeClass('edubin-mobile-menu-close--active');
        $('.edubin-mobile-menu-nav-wrapper').removeClass('edubin-mobile-menu-visible');
        $('body').removeClass('edubin-mobile-menu-active');
    });
    //===== Accordion Menu for Mobile
    $.fn.extend({
        accordionMenu: function(options) {
            var defaults = {
                speed: 400
            };
            var options = $.extend(defaults, options);
            return this.each(function() {
                $(this).addClass('edubin-mobile-menu-item');
                var menuItems = $(this).children('li');
                menuItems.find('.edubin-mobile-menu-item > .edubin-dropdown-menu').parent().addClass('menu-item-has-children');
                $('.edubin-mobile-menu-item .menu-item-has-children .edubin-dropdown-menu').hide();
                $('.edubin-mobile-menu-item .menu-item-has-children > a .edubin-menu-icon').on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    $(this).parent().siblings('.edubin-dropdown-menu').slideToggle(options.speed);
                    $(this).parent().siblings('.edubin-mega-menu').slideToggle(options.speed);
                });
            });
        }
    });
    $('#edubin-mobile-menu-item').accordionMenu();
    //===== Elementor Mobile Menu
    $('.edubin-elementor-mobile-hamburger-menu > a').on('click', function(e) {
        e.preventDefault();
        $(this).toggleClass('edubin-mobile-menu-close--active');
        $(".edubin-elementor-mobile-menu-nav-wrapper").toggleClass('edubin-mobile-menu-visible');
        $('body').toggleClass('edubin-mobile-menu-active');
    });
    $('.edubin-elementor-mobile-menu-close > a').on('click', function(e) {
        e.preventDefault();
        $('.edubin-elementor-mobile-hamburger-menu > a').removeClass('edubin-mobile-menu-close--active');
        $('.edubin-elementor-mobile-menu-nav-wrapper').removeClass('edubin-mobile-menu-visible');
        $('body').removeClass('edubin-mobile-menu-active');
    });
    $('.edubin-elementor-mobile-menu-overlay').on('click', function(e) {
        e.preventDefault();
        $('.edubin-elementor-mobile-hamburger-menu > a').removeClass('edubin-mobile-menu-close--active');
        $('.edubin-elementor-mobile-menu-nav-wrapper').removeClass('edubin-mobile-menu-visible');
        $('body').removeClass('edubin-mobile-menu-active');
    });
    //===== Accordion Menu for Elementor Mobile
    $.fn.extend({
        accordionMenu: function(options) {
            var defaults = {
                speed: 400
            };
            var options = $.extend(defaults, options);
            return this.each(function() {
                $(this).addClass('edubin-elementor-mobile-menu-item');
                var menuItems = $(this).children('li');
                menuItems.find('.edubin-elementor-mobile-menu-item > .edubin-dropdown-menu').parent().addClass('menu-item-has-children');
                $('.edubin-elementor-mobile-menu-item .menu-item-has-children .edubin-dropdown-menu').hide();
                $('.edubin-elementor-mobile-menu-item .menu-item-has-children > a .edubin-menu-icon').on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    $(this).parent().siblings('.edubin-dropdown-menu').slideToggle(options.speed);
                    $(this).parent().siblings('.edubin-mega-menu').slideToggle(options.speed);
                });
            });
        }
    });
    $('#edubin-elementor-mobile-menu-item').accordionMenu();
    //===== WooCommerce Helper
    function edubin_woocommerce_helper() {
        $('.product-over-info ul li.add-to-cart a.add_to_cart_button.ajax_add_to_cart').on("click", function() {
            $(this).closest('li').addClass('added_to_cart_item');
        });
    }
    //===== SAL Animation
    sal();
    //===== Video Popup
    $(function() {
        $("a.bla-1").YouTubePopUp();
        $("a.bla-2").YouTubePopUp({
            autoplay: 0
        });
    });
    //===== Search
    $('#search').on('click', function() {
        $(".edubin-search-box").fadeIn(600);
    });
    $('.top-search').on('click', function() {
        $(".edubin-search-box").fadeIn(600);
    });
    $('.edubin-closebtn').on('click', function() {
        $(".edubin-search-box").fadeOut(600);
    });
    //===== Like/Wishlist button for blog page
    jQuery(document).ready(function($) {
        if (typeof edubin_like_ajax === 'undefined') {
            return; // Exit if wp_localize_script is disabled
        }
        $('.edubin-like-btn').on('click', function(event) {
            event.preventDefault();
            var button = $(this);
            var postID = button.data('postid');
            $.ajax({
                type: 'POST',
                url: edubin_like_ajax.ajaxurl,
                data: {
                    action: 'edubin_like',
                    post_id: postID
                },
                success: function(response) {
                    if (response.success) {
                        button.find('.like-count').text(response.data);
                    }
                }
            });
        });
    });
    //===== Add to cart animation
    jQuery(function($) {
        // Woo Add-to-Cart Animation
        if (typeof edubin_cart !== 'undefined' && edubin_cart.animate) {
            $(document).on("click", ".add_to_cart_button", function(e) {
                let t = $(".edubin-woo-mini-cart-total-item");
                if (!t.length) return;
                let fly = $('<span class="flying-number">+1</span>').appendTo("body");
                fly.css({
                    top: e.pageY,
                    left: e.pageX,
                    position: "absolute",
                    fontWeight: "bold",
                    zIndex: 9999
                });
                fly.animate({
                    top: t.offset().top,
                    left: t.offset().left,
                    opacity: 0
                }, 800, () => fly.remove());
                setTimeout(() => t.text(parseInt(t.text()) + 1), 300);
            });
        }
        // Tutor Add > reload count
        $(document).on("click", ".tutor-native-add-to-cart", () => setTimeout(() => location.reload(), 500));
        // Tutor remove from cart
        $(document).on("click", ".tutor-cart-remove-button", function(e) {
            e.preventDefault();
            let id = $(this).data("course-id");
            $.post(edubin_cart.ajax, {
                action: "tutor_delete_course_from_cart",
                course_id: id
            }, () => location.reload());
        });
    });
})(jQuery);