<?php
defined( 'ABSPATH' ) || exit;

function edubin_ocdi_before_content_import($selected_import)
{
    // Customizer reset
    delete_option('theme_mods_' . get_option('stylesheet'));
    // Old style.
    $theme_name = get_option('current_theme');
    if (false === $theme_name) {
        $theme_name = wp_get_theme()->get('edubin');
    }
    delete_option('mods_' . $theme_name);
    
        $learnpress_imports = ['LearnPress LMS'];
        $learndash_imports = ['LearnDash LMS'];
        $tutor_imports = ['Tutor LMS'];
        $sensei_imports = ['Sensei LMS'];   
        $masterstudy_imports = ['Masterstudy LMS'];
        $lifter_imports = ['Lifter LMS'];
        $rtl_lp_imports = ['RTL (LearnPress LMS)'];
        
        // Check LearnPess LMS
        if (in_array($selected_import['import_file_name'], $learnpress_imports)) {

        if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }

        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
        
    } 

    // Check Tutor LMS
    elseif (in_array($selected_import['import_file_name'], $tutor_imports)) {

        if (class_exists('LearnPress')) {
            deactivate_plugins('/learnpress/learnpress.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 

    // Check LearnDash LMS
    elseif (in_array($selected_import['import_file_name'], $learndash_imports)) {

        if (class_exists('LearnPress')) {
            deactivate_plugins('/learnpress/learnpress.php');
        }
        if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 
    
    // Check Masterstudy LMS
    elseif (in_array($selected_import['import_file_name'], $masterstudy_imports)) {

        if (class_exists('LearnPress')) {
            deactivate_plugins('/learnpress/learnpress.php');
        }
        if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 
    
    // Check Sensei LMS
    elseif (in_array($selected_import['import_file_name'], $sensei_imports)) {
        
        if (class_exists('LearnPress')) {
            deactivate_plugins('/learnpress/learnpress.php');
        }
        if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 
    // Check LifterLMS
    elseif (in_array($selected_import['import_file_name'], $lifter_imports)) {
        
        if (class_exists('LearnPress')) {
            deactivate_plugins('/learnpress/learnpress.php');
        }
        if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 
    // Check RTL
    elseif (in_array($selected_import['import_file_name'], $rtl_lp_imports)) {
        
     if (function_exists('tutor')) {
            deactivate_plugins('/tutor/tutor.php');
        }
        if (function_exists('tutor_pro')) {
            deactivate_plugins('/tutor-pro/tutor-pro.php');
        }
        if (class_exists('SFWD_LMS')) {
            deactivate_plugins('/sfwd-lms/sfwd_lms.php');
        }
        if (class_exists('MasterStudy\Lms\Plugin')) {
            deactivate_plugins('/masterstudy-lms-learning-management-system/masterstudy-lms-learning-management-system.php');
        }
        if (class_exists('LifterLMS' )) {
            deactivate_plugins('/lifterlms/lifterlms.php');
        }
        if (class_exists('Sensei_Main' )) {
            deactivate_plugins('/sensei-lms/sensei-lms.php');
        }
        global $wp_rewrite;
        $wp_rewrite->set_permalink_structure('/%postname%/');
    } 
    
}
add_action('ocdi/before_content_import', 'edubin_ocdi_before_content_import');

