<?php
defined( 'ABSPATH' ) || exit;

function edubin_ocdi_import_update_options( $file ) {
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
    $file_obj = new WP_Filesystem_Direct( array() );
    $datas = $file_obj->get_contents($file);
    $datas = json_decode( $datas, true );

    if ( count( array_filter( $datas ) ) < 1 ) :
        return;
    endif;

    if ( ! empty( $datas['page_options'] ) ) :
        edubin_ocdi_import_page_options( $datas['page_options'] );
    endif;
}

function edubin_ocdi_import_page_options( $datas ) {
    if ( $datas ) :
        foreach ( $datas as $option_name => $page_id ) :
            update_option( $option_name, $page_id );
        endforeach;
    endif;
}

function edubin_after_import_setup($selected_import)
{
    // Assign menus to their locations.
    $main_menu   = get_term_by('name', 'Primary', 'nav_menu');
    $footer_menu = get_term_by('name', 'Footer Menu', 'nav_menu');

    set_theme_mod('nav_menu_locations', array(
        'primary'     => $main_menu->term_id,
        'footer_menu' => $footer_menu->term_id,
    )
    );
    // LearnPress LMS
    if ('LearnPress LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-learning-space-learnpress');
    } 
    // Tutor LMS
    elseif ('Tutor LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-online-learning-tutor');
    }
    // LearnDash LMS
    elseif ('LearnDash LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-online-academy-learndash');
    } 
    // Masterstudy LMS
    elseif ('Masterstudy LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-learning-space-masterstudy');
    } 
    // Sensei LMS
    elseif ('Sensei LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-online-academy-sensei');
    } 
    // Lifter LMS
    elseif ('Lifter LMS' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('home-learning-space-lifter');
    }
    // RTL LearnPress LMS
    if ('RTL (LearnPress LMS)' === $selected_import['import_file_name']) {
        $front_page_id = get_page_by_path('rtl-home-learning-space-learnpress');
    } 

    $blog_page_id = get_page_by_title('Blog');
    update_option('show_on_front', 'page');
    $shop_page_id     = get_page_by_title( 'Shop' );
    $cart_page_id     = get_page_by_title( 'Cart' );
    $checkout_page_id = get_page_by_title( 'Checkout' );

    update_option('page_on_front', $front_page_id->ID);
    update_option('page_for_posts', $blog_page_id->ID);

    update_option( 'woocommerce_shop_page_id', $shop_page_id->ID );
    update_option( 'woocommerce_cart_page_id', $cart_page_id->ID );
    update_option( 'woocommerce_checkout_page_id', $checkout_page_id->ID );
    update_option( 'woocommerce_enable_myaccount_registration', 'yes' );

    update_option( 'elementor_container_width', 1200 );
    update_option( 'elementor_disable_color_schemes', 'yes' );
    update_option( 'elementor_disable_typography_schemes', 'yes' );
    update_option( 'elementor_global_image_lightbox', 0 );

    $file = trailingslashit( get_template_directory() ) . 'admin/update_options.json';
    if ( file_exists( $file ) ) :
        edubin_ocdi_import_update_options($file);
    endif;

    // Reset site permalink
    global $wp_rewrite;
    $wp_rewrite->set_permalink_structure('/%postname%/');

}
add_action('ocdi/after_import', 'edubin_after_import_setup');
