<?php
defined( 'ABSPATH' ) || exit;

    $allowed_html = [
        'a' => [ 'href' => true, 'target' => true ],
    ]; 
?>
    
    <h2 class="nav-tab-wrapper">
        <?php

        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=edubin-admin-menu' ), esc_html__( 'Dashboard', 'edubin' ) );

        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'customize.php' ), esc_html__( 'Theme Options', 'edubin' ) );

        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=edubin-requirements' ), esc_html__( 'System Status', 'edubin' ) );

        printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'admin.php?page=edubin-theme-active' ), esc_html__( 'Activate Theme', 'edubin' ) );

        if (class_exists('OCDI_Plugin')):
            printf( '<a href="%s" class="nav-tab">%s</a>', admin_url( 'themes.php?page=pt-one-click-demo-import' ), esc_html__( 'Demo Import', 'edubin' ) );
        endif;
        
        ?>
    </h2>

<div class="edubin-theme-helper">
    <div class="container-form">

        <div class="edubin-row">
            <div class="edubin-col edubin-col-8">
                <div class="edubin-col_inner">
                    <div class="edubin-info-box_wrapper">
                        <div class="edubin-info-box">
     
                            <div class="edubin-info-box_content-wrapper">
                                <div class="edubin-info-box_title">
                                    <h3 class="edubin-info-box_icon-heading">
                                        <?php
                                            esc_html_e('Welcome to Edubin', 'edubin');
                                        ?>
                                    </h3>
                                </div>
                                <div class="edubin-info-box_content">
                                    <p>
                                        <?php
                                        esc_html_e('If you haven’t used the setup wizard yet, just follow the steps below to get the most out of the Edubin theme by Pixelcurve.', 'edubin');
                                        ?>
                                    </p>
                                </div>
                                <div class="edubin-info-box_btn">
                                    <a href="<?php echo admin_url( 'admin.php?page=edubin-setup' ); ?>" class="button-primary button-large button-next"><?php echo __( 'Getting Started', 'edubin' ); ?></a>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="edubin-col edubin-col-4">
                <div class="edubin-col_inner">
                    <div class="edubin-info-box_wrapper">
                        <div class="edubin-info-box edubin--setting">

                            <div class="tc-box-header">
                              <h3 class="box-title"><?php echo __( 'Quick Settings', 'edubin' ); ?></h3>
                              <a href="<?php echo admin_url( 'customize.php' ); ?>" class="sub_link"><?php echo __( 'Go to Customize', 'edubin' ); ?></a>
                            </div>
                                            
                            <div class="td-box-welcome-admin">
                                <div class="tc-box-body">
                                  <div class="text-panel-customizer">
                                    <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_general_panel' ); ?>"><?php echo __( 'General', 'edubin' ); ?></a>
                                    <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=header_naviation_panel' ); ?>"><?php echo __( 'Header', 'edubin' ); ?></a>
                                    <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_general_panel' ); ?>"><?php echo __( 'Typography', 'edubin' ); ?></a>
                                    <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=header_blog_panel' ); ?>"><?php echo __( 'Blog', 'edubin' ); ?></a>
                                    <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_footer_panel' ); ?>"><?php echo __( 'Footer', 'edubin' ); ?></a>

                                    <?php if (function_exists('tutor')): ?>
                                        <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_tutor_panel' ); ?>"><?php echo __( 'Tutor LMS', 'edubin' ); ?></a>
                                    <?php endif; ?>

                                    <?php if (class_exists('LearnPress')): ?>
                                        <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_lp_panel' ); ?>"><?php echo __( 'LearnPress LMS', 'edubin' ); ?></a>
                                    <?php endif; ?>

                                    <?php if ( class_exists( 'WooCommerce' ) ) : ?>
                                        <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=woocommerce' ); ?>"><?php echo __( 'WooCommerce', 'edubin' ); ?></a>
                                    <?php endif; ?>
                                    
                                    <?php if ( class_exists( 'WPEMS' ) ) : ?>                                    
                                        <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=edubin_tp_event_panel' ); ?>"><?php echo __( 'WP Event Manager', 'edubin' ); ?></a>
                                    <?php endif; ?>

                                    <?php if ( class_exists( 'Tribe__Events__Main' ) ) : ?>    
                                        <a class="tc-button-box tc-base-color" target="_blank" href="<?php echo admin_url( 'customize.php?autofocus[panel]=tribe_customizer' ); ?>"><?php echo __( 'The Event Calendar', 'edubin' ); ?></a>
                                    <?php endif; ?>
                                    
                                  </div>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
 
        </div>

        <div class="edubin-row">

            <div class="edubin-col edubin-col-4">
                <div class="edubin-col_inner">
                    <div class="edubin-info-box_wrapper">
                        <div class="edubin-info-box">
                            <div class="edubin-info-box_icon-wrapper">
                                <div class="edubin-info-box_icon">
                                    <img src="<?php echo esc_url(EDUBIN_URI) . '/admin/assets/images/document_icon.png'?>">
                                </div>
                            </div>
                            <div class="edubin-info-box_content-wrapper">
                                <div class="edubin-info-box_title">
                                    <h3 class="edubin-info-box_icon-heading">
                                        <?php
                                            esc_html_e('Documentation', 'edubin');
                                        ?>
                                    </h3>
                                </div>
                                <div class="edubin-info-box_content">
                                    <p>
                                        <?php
                                        esc_html_e('Before submitting a ticket, please read the documentation. Probably, your issue already described.', 'edubin');
                                        ?>
                                    </p>
                                </div>
                                <div class="edubin-info-box_btn">
                                    <a target="_blank" href="https://thepixelcurve.com/support/docs/edubin/">
                                        <?php
                                            esc_html_e('Visit Documentation', 'edubin');
                                        ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="edubin-col edubin-col-4">
                <div class="edubin-col_inner">
                    <div class="edubin-info-box_wrapper">
                        <div class="edubin-info-box">
                            <div class="edubin-info-box_icon-wrapper">
                                <div class="edubin-info-box_icon">
                                    <img src="<?php echo esc_url(EDUBIN_URI) . '/admin/assets/images/video_icon.png'?>">
                                </div>
                            </div>
                            <div class="edubin-info-box_content-wrapper">
                                <div class="edubin-info-box_title">
                                    <h3 class="edubin-info-box_icon-heading">
                                        <?php
                                            esc_html_e('Video Tutorials', 'edubin');
                                        ?>
                                    </h3>
                                </div>
                                <div class="edubin-info-box_content">
                                    <p>
                                        <?php
                                            esc_html_e('There you can watch tutorial for main issues. How to import demo content? How to create a course? etc..', 'edubin');
                                        ?>
                                    </p>
                                </div>
                                <div class="edubin-info-box_btn">
                                    <a target="_blank" href="https://www.youtube.com/@thepixelcurve/playlists">
                                        <?php
                                            esc_html_e('Watch Tutorials', 'edubin');
                                        ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="edubin-col edubin-col-4">
                <div class="edubin-col_inner">
                    <div class="edubin-info-box_wrapper">
                        <div class="edubin-info-box">
                            <div class="edubin-info-box_icon-wrapper">
                                <div class="edubin-info-box_icon">
                                    <img src="<?php echo esc_url(EDUBIN_URI) . '/admin/assets/images/support_icon.png'?>">
                                </div>
                            </div>
                            <div class="edubin-info-box_content-wrapper">
                                <div class="edubin-info-box_title">
                                    <h3 class="edubin-info-box_icon-heading">
                                        <?php
                                            esc_html_e('Support forum', 'edubin');
                                        ?>
                                    </h3>
                                </div>
                                <div class="edubin-info-box_content">
                                    <p>
                                        <?php
                                            esc_html_e('If you did not find an answer to your question, submit a ticket with well describe your issue.', 'edubin');
                                        ?>
                                    </p>
                                </div>
                                <div class="edubin-info-box_btn">
                                    <a target="_blank" href="https://thepixelcurve.com/support/">
                                        <?php
                                            esc_html_e('Create a ticket', 'edubin');
                                        ?>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="theme-helper_desc">
            <?php
                echo wp_kses( __( 'Do You have some other questions? Need Customization? Pre-purchase questions? Ask it <a  target="_blank"  href="mailto:help.pixelcurve@gmail.com">there!</a>', 'edubin' ), $allowed_html);
            ?>
        </div>

    </div>
</div>

