<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
global $pagenow;

function edubin_welcome_page() {
   require_once get_theme_file_path( 'admin/admin-pages/edubin-welcome.php' );
}
function edubin_theme_active_page(){
   require_once get_theme_file_path( 'admin/admin-pages/edubin-theme-active.php' );
}

// function edubin_help_center_page(){
//    require_once get_theme_file_path( 'admin/admin-pages/edubin-help-center.php' );
// }

function edubin_requirements_page(){
   require_once get_theme_file_path( 'admin/admin-pages/edubin-requirements.php' );
}

function edubin_admin_menu(){
    if ( current_user_can( 'edit_theme_options' ) ) {

      add_menu_page( 'Edubin', esc_html__('Edubin','edubin'), 'administrator', 'edubin-admin-menu', 'edubin_welcome_page', EDUBIN_URI . '/assets/images/fav.svg', 4 );

      add_submenu_page( 'edubin-admin-menu', 'edubin', esc_html__('Dashboard','edubin'), 'administrator', 'edubin-admin-menu', 'edubin_welcome_page' );

      add_submenu_page('edubin-admin-menu', '', 'Theme Options', 'manage_options', 'customize.php' );

      add_submenu_page( 'edubin-admin-menu', 'edubin', esc_html__('System Status','edubin'), 'administrator', 'edubin-requirements', 'edubin_requirements_page' );

      add_submenu_page( 'edubin-admin-menu', 'edubin', esc_html__('Activate Theme','edubin'), 'administrator', 'edubin-theme-active', 'edubin_theme_active_page' );
      
      if (class_exists('OCDI_Plugin')):
        add_submenu_page( 'edubin-admin-menu', esc_html__( 'Demo Import', 'edubin' ), esc_html__( 'Demo Import', 'edubin' ), 'administrator', 'demo_install', 'demo_install_function' );
      endif;

     // add_submenu_page( 'edubin-admin-menu', 'edubin', esc_html__('Help Center','edubin'), 'administrator', 'edubin-help-center', 'edubin_help_center_page' );

   }

}

add_action( 'admin_menu', 'edubin_admin_menu' );

function demo_install_function(){
   wp_redirect( esc_url( admin_url( 'themes.php?page=pt-one-click-demo-import' ) ) );
    exit; // Always use exit after wp_redirect to ensure the script stops execution.
}

if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {

	wp_redirect(admin_url("admin.php?page=edubin-admin-menu"));
	
}

