<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Edubin
 */

get_header();
	?>
	<section class="edubin-main-content-inner error-page-area">
		<div class="edubin-container">
			<div class="edu-error">
				<div class="thumbnail">
					<svg version="1.2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 380 281" width="380" height="281">
						<title><?php echo __( '404 SVG', 'edubin' ); ?></title>
						<style>
							tspan { white-space:pre } 
							.s0 { fill: #f5df60 } 
							.s1 { fill: none;stroke: #000000;stroke-linecap: round;stroke-linejoin: round;stroke-width: 1.9 } 
							.s2 { fill: none;stroke: #000000;stroke-miterlimit:10;stroke-width: 2.8 } 
							.s3 { fill: none } 
							.s4 { fill: none;stroke: #000000;stroke-linecap: round;stroke-linejoin: round;stroke-width: 1.9;stroke-dasharray: 2.7978997379618216,6.528461264626936 } 
							.s5 { fill: none;stroke: #000000;stroke-linecap: round;stroke-linejoin: round;stroke-width: 1.7;stroke-dasharray: 2.6088327870384944,6.087219417657778 } 
						</style>
						<g id="OBJECTS_copia">
							<g id="Layer">
								<path id="Layer" fill-rule="evenodd" class="s0" d="m141.1 195h-11.3v19.8h-27.1v-19.8h-40.7v-20.2l42.4-62h25.4v61.6h11.3c0 0 0 20.6 0 20.6zm-38.4-20.6v-11.8q0-3.4 0.2-9.1 0.3-5.6 0.4-5.9h-0.8q-2.3 5.3-5.3 10l-11.3 16.8z"/>
								<path id="Layer" fill-rule="evenodd" class="s0" d="m221.9 163.9q0 27.1-9.1 39.7-9.1 12.6-27.7 12.6-18.3 0-27.6-13.2-9.3-13.1-9.3-39.1 0-27.2 9.1-39.9 9.1-12.7 27.8-12.7 18.1 0 27.5 13.2 9.3 13.2 9.3 39.4zm-46.3 0q0 17.3 2.2 23.8 2.2 6.5 7.3 6.5 5.1 0 7.2-6.7 2.2-6.7 2.2-23.6 0-17-2.2-23.8-2.2-6.8-7.2-6.8-5.1 0-7.3 6.6-2.2 6.6-2.2 24z"/>
								<path id="Layer" fill-rule="evenodd" class="s0" d="m308.4 195h-11.3v19.8h-27.2v-19.8h-40.6v-20.2l42.4-62h25.4v61.6h11.3zm-38.5-20.5v-11.9q0-3.4 0.3-9 0.2-5.7 0.4-6h-0.8q-2.4 5.4-5.4 10l-11.2 16.9z"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m21.2 135.4h41.2"/>
								<path id="Layer" class="s1" d="m72.3 135.4h8.8"/>
								<path id="Layer" class="s1" d="m13.7 123.8h73.8"/>
								<path id="Layer" class="s1" d="m7.7 123.8h-6.1"/>
								<path id="Layer" class="s1" d="m13.7 112.8h24.5"/>
								<path id="Layer" class="s1" d="m44.8 112.8h51.4"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m312.4 227.5h44.1"/>
								<path id="Layer" class="s1" d="m363.7 227.5h6.3"/>
								<path id="Layer" class="s1" d="m321.2 215.9h57.8"/>
								<path id="Layer" class="s1" d="m316.8 215.9h-4.4"/>
								<path id="Layer" class="s1" d="m312.4 204.8h26.6"/>
								<path id="Layer" class="s1" d="m343.7 204.8h20"/>
							</g>
							<g id="Layer">
								<path id="Layer" fill-rule="evenodd" class="s2" d="m146.3 194.6h-11.2v19.8h-27.2v-19.8h-40.6v-20.2l42.4-62h25.4v61.6h11.2c0 0 0 20.6 0 20.6zm-38.4-20.6v-11.8q0-3.4 0.3-9.1 0.2-5.6 0.4-5.9h-0.8q-2.4 5.4-5.4 10l-11.3 16.8z"/>
								<path id="Layer" fill-rule="evenodd" class="s2" d="m227.1 163.5q0 27.1-9 39.7-9.1 12.6-27.8 12.6-18.2 0-27.5-13.2-9.3-13.1-9.3-39.1 0-27.2 9.1-39.9 9-12.7 27.7-12.7 18.2 0 27.5 13.2 9.3 13.2 9.3 39.4zm-46.2 0q0 17.3 2.2 23.8 2.1 6.5 7.2 6.5 5.2 0 7.3-6.7 2.1-6.7 2.1-23.6 0-16.9-2.1-23.7-2.2-6.9-7.3-6.9-5.1 0.1-7.2 6.6-2.2 6.6-2.2 24z"/>
								<path id="Layer" fill-rule="evenodd" class="s2" d="m313.6 194.6h-11.2v19.8h-27.2v-19.8h-40.6v-20.2l42.4-62h25.4v61.6h11.2c0 0 0 20.6 0 20.6zm-38.4-20.6v-11.8q0-3.4 0.3-9.1 0.2-5.6 0.4-5.9h-0.8q-2.4 5.4-5.4 10l-11.3 16.8z"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m331.6 132.9v-9.5"/>
								<path id="Layer" class="s1" d="m325 135.6l-6.6-6.7"/>
								<path id="Layer" class="s1" d="m322.3 142.2h-9.4"/>
								<path id="Layer" class="s1" d="m325 148.8l-6.6 6.7"/>
								<path id="Layer" class="s1" d="m331.6 151.5v9.5"/>
								<path id="Layer" class="s1" d="m338.2 148.8l6.7 6.7"/>
								<path id="Layer" class="s1" d="m341 142.2h9.4"/>
								<path id="Layer" class="s1" d="m338.2 135.6l6.7-6.7"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m35.3 180v-6.9"/>
								<path id="Layer" class="s1" d="m30.5 181.9l-4.8-4.8"/>
								<path id="Layer" class="s1" d="m28.6 186.7h-6.9"/>
								<path id="Layer" class="s1" d="m30.5 191.5l-4.8 4.8"/>
								<path id="Layer" class="s1" d="m35.3 193.5v6.8"/>
								<path id="Layer" class="s1" d="m40.1 191.5l4.8 4.8"/>
								<path id="Layer" class="s1" d="m42.1 186.7h6.8"/>
								<path id="Layer" class="s1" d="m40.1 181.9l4.8-4.8"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m220.1 38.8v-6.9"/>
								<path id="Layer" class="s1" d="m215.3 40.7l-4.8-4.8"/>
								<path id="Layer" class="s1" d="m213.4 45.5h-6.9"/>
								<path id="Layer" class="s1" d="m215.3 50.3l-4.8 4.8"/>
								<path id="Layer" class="s1" d="m220.1 52.3v6.8"/>
								<path id="Layer" class="s1" d="m224.9 50.3l4.8 4.8"/>
								<path id="Layer" class="s1" d="m226.9 45.5h6.8"/>
								<path id="Layer" class="s1" d="m224.9 40.7l4.8-4.8"/>
							</g>
							<path id="Layer" class="s3" d="m69.2 279.5h235.5v26.2h-235.5z"/>
							<path id="Layer" class="s1" d="m87.5 96.1v-29.6h153.6v65.8"/>
							<path id="Layer" class="s1" d="m186.9 45.5v37.1h101.9v16.8"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m87.5 103.5c-2.1 0-3.7-1.7-3.7-3.7 0-2 1.6-3.7 3.7-3.7 2 0 3.6 1.7 3.6 3.7 0 2-1.6 3.7-3.6 3.7z"/>
							<path id="Layer" class="s1" d="m186.9 45.5c-2 0-3.6-1.6-3.6-3.7 0-2 1.6-3.6 3.6-3.6 2.1 0 3.7 1.6 3.7 3.6 0 2.1-1.6 3.7-3.7 3.7z"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m288.8 107.1c-2 0-3.6-1.6-3.6-3.6 0-2.1 1.6-3.7 3.6-3.7 2 0 3.7 1.6 3.7 3.7 0 2-1.7 3.6-3.7 3.6z"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m241.1 140.2c-2 0-3.7-1.6-3.7-3.7 0-2 1.7-3.6 3.7-3.6 2 0 3.7 1.6 3.7 3.6 0 2.1-1.7 3.7-3.7 3.7z"/>
							<g id="Layer">
								<path id="Layer" class="s1" d="m63.6 210l-8.7 8.7"/>
								<path id="Layer" class="s1" d="m54.9 210l8.7 8.7"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m67.9 84l-8.7 8.6"/>
								<path id="Layer" class="s1" d="m59.2 84l8.7 8.6"/>
							</g>
							<g id="Layer">
								<path id="Layer" class="s1" d="m349.2 182.4l-8.6 8.7"/>
								<path id="Layer" class="s1" d="m340.6 182.4l8.6 8.7"/>
							</g>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m103.1 34.4c-2.8 0-5.3 1-7.3 2.7-2-6.1-7.7-10.5-14.4-10.5-7.5 0-13.7 5.5-14.9 12.7q-1.2-0.4-2.5-0.4c-5 0-9.1 4.1-9.1 9.1 0 4.6 3.4 8.4 7.9 9v0.1h40.3c6.3 0 11.3-5.1 11.3-11.4 0-6.2-5-11.3-11.3-11.3z"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m312.9 92c2 0 3.9 0.7 5.3 1.9 1.4-4.3 5.6-7.5 10.5-7.5 5.4 0 9.9 4 10.8 9.2q0.9-0.3 1.8-0.3c3.7 0 6.6 3 6.6 6.6 0 3.3-2.5 6.1-5.7 6.5v0.1h-29.3c-4.5 0-8.2-3.7-8.2-8.2 0-4.6 3.7-8.3 8.2-8.3z"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m353.3 247.7c-1.7 0-3.2 0.6-4.4 1.6-1.3-3.7-4.7-6.3-8.8-6.3-4.6 0-8.4 3.3-9.1 7.7q-0.8-0.3-1.6-0.3c-3 0-5.5 2.5-5.5 5.6 0 2.8 2.1 5.1 4.8 5.4v0.1h24.6c3.8 0 6.9-3.1 6.9-6.9 0-3.8-3.1-6.9-6.9-6.9z"/>
							<path id="Layer" fill-rule="evenodd" class="s1" d="m19.9 233.1c2 0 3.9 0.7 5.3 1.9 1.4-4.4 5.6-7.5 10.5-7.5 5.4 0 9.9 4 10.8 9.2q0.9-0.3 1.8-0.3c3.7 0 6.6 3 6.6 6.6 0 3.3-2.5 6.1-5.7 6.5v0.1h-29.3c-4.5 0-8.2-3.7-8.2-8.2 0-4.6 3.7-8.3 8.2-8.3z"/>
							<path id="Layer" fill-rule="evenodd" class="s4" d="m114.4 29c0 0 51.7-42.2 122-22.8 73.9 20.4 88.6 73.1 88.6 73.1"/>
							<path id="Layer" fill-rule="evenodd" class="s5" d="m36.3 151.7c-20 3.1-30.1 45.7-7.6 62.6"/>
							<path id="Layer" fill-rule="evenodd" class="s4" d="m288.8 274.6c0 0 34.4 15 49.4-5.9"/>
							<path id="Layer" class="s1" d="m125.4 103.5v-21.8"/>
							<path id="Layer" class="s1" d="m120.2 103.5v-10.9"/>
							<path id="Layer" class="s1" d="m205.1 108.5v-15.9"/>
							<path id="Layer" class="s1" d="m199.2 107.1v-6.6"/>
							<path id="Layer" class="s1" d="m193.9 107.1v-11"/>
							<path id="Layer" class="s1" d="m130.4 103.5v-10.9"/>
							<path id="Layer" class="s1" d="m274.2 106.5v-4.9"/>
							<path id="Layer" class="s1" d="m269 106.5v-11.8"/>
							<path id="Layer" class="s1" d="m279.2 106.5v-8.5"/>
						</g>
					</svg>
				</div>

				<div class="content">
					<?php
						$error_page_title = Edubin::setting( 'error_404_heading' );
						$error_page_desc =  Edubin::setting( 'error_404_text' );

						if ( ! empty( $error_page_title ) ) :
							echo '<h2 class="title">' . wp_kses_post( $error_page_title ) . '</h2>';
						endif;

						if ( ! empty( $error_page_desc ) ) :
							echo '<h4 class="subtitle">' . wp_kses_post( $error_page_desc ) . '</h4>';
						endif;
					?>
					<a href="<?php echo esc_url( get_site_url() );?>" class="edu-btn"><i class="icon-west"></i><?php echo __( 'Back to Homepage', 'edubin' ); ?></a>
				</div>
			</div>
		</div>
		</section>
	<?php
get_footer();