<?php

namespace Uncanny_Automator_Pro;

use Uncanny_Automator\Recipe\Trigger;

/**
 * Class ANON_ORDER_CREATED
 *
 * @package Uncanny_Automator_Pro
 */
class ANON_ORDER_CREATED extends Trigger {

	const TRIGGER_CODE = 'ANONORDERCREATED';
	const TRIGGER_META = 'WCORDERCREATED';

	/**
	 * @method \Uncanny_Automator_Pro\Woocommerce_Pro_Helpers get_item_helpers()
	 */

	protected function setup_trigger() {
		$this->set_integration( 'WC' );
		$this->set_trigger_code( self::TRIGGER_CODE );
		$this->set_trigger_meta( self::TRIGGER_META );
		$this->set_is_pro( true );
		$this->set_trigger_type( 'anonymous' );

		$this->add_action( 'woocommerce_new_order' );
		$this->set_action_args_count( 1 );

		$this->set_sentence( esc_html_x( 'An order is created', 'Woocommerce', 'uncanny-automator-pro' ) );

		$this->set_readable_sentence( esc_html_x( 'An order is created', 'Woocommerce', 'uncanny-automator-pro' ) );
	}
	/**
	 * Options.
	 *
	 * @return mixed
	 */
	public function options() {
		return array();
	}
	/**
	 * Validate.
	 *
	 * @param mixed $trigger The trigger.
	 * @param mixed $hook_args The arguments.
	 * @return mixed
	 */
	public function validate( $trigger, $hook_args ) {
		list( $order_id ) = $hook_args;

		if ( ! $order_id ) {
			return false;
		}

		$order = wc_get_order( $order_id );

		if ( ! $order ) {
			return false;
		}

		return true;
	}
	/**
	 * Hydrate tokens.
	 *
	 * @param mixed $trigger The trigger.
	 * @param mixed $hook_args The arguments.
	 * @return mixed
	 */
	public function hydrate_tokens( $trigger, $hook_args ) {
		list( $order_id ) = $hook_args;

		$order = wc_get_order( $order_id );

		if ( ! $order ) {
			return array();
		}

		return array(
			'ORDER_ID'            => $order_id,
			'ORDER_NUMBER'        => $order->get_order_number(),
			'ORDER_STATUS'        => $order->get_status(),
			'ORDER_TOTAL'         => $order->get_total(),
			'ORDER_CURRENCY'      => $order->get_currency(),
			'ORDER_DATE'          => $order->get_date_created()->format( 'Y-m-d H:i:s' ),
			'CUSTOMER_ID'         => $order->get_customer_id(),
			'CUSTOMER_EMAIL'      => $order->get_billing_email(),
			'CUSTOMER_FIRST_NAME' => $order->get_billing_first_name(),
			'CUSTOMER_LAST_NAME'  => $order->get_billing_last_name(),
			'CUSTOMER_PHONE'      => $order->get_billing_phone(),
			'BILLING_ADDRESS'     => $order->get_formatted_billing_address(),
			'SHIPPING_ADDRESS'    => $order->get_formatted_shipping_address(),
		);
	}
	/**
	 * Define tokens.
	 *
	 * @param mixed $trigger The trigger.
	 * @param mixed $tokens The destination.
	 * @return mixed
	 */
	public function define_tokens( $trigger, $tokens ) {
		$custom_tokens = array(
			array(
				'tokenId'   => 'ORDER_ID',
				'tokenName' => esc_html_x( 'Order ID', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'ORDER_NUMBER',
				'tokenName' => esc_html_x( 'Order number', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'ORDER_STATUS',
				'tokenName' => esc_html_x( 'Order status', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'ORDER_TOTAL',
				'tokenName' => esc_html_x( 'Order total', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'ORDER_CURRENCY',
				'tokenName' => esc_html_x( 'Order currency', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'ORDER_DATE',
				'tokenName' => esc_html_x( 'Order date', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'CUSTOMER_ID',
				'tokenName' => esc_html_x( 'Customer ID', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'int',
			),
			array(
				'tokenId'   => 'CUSTOMER_EMAIL',
				'tokenName' => esc_html_x( 'Customer email', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'email',
			),
			array(
				'tokenId'   => 'CUSTOMER_FIRST_NAME',
				'tokenName' => esc_html_x( 'Customer first name', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'CUSTOMER_LAST_NAME',
				'tokenName' => esc_html_x( 'Customer last name', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'CUSTOMER_PHONE',
				'tokenName' => esc_html_x( 'Customer phone', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'BILLING_ADDRESS',
				'tokenName' => esc_html_x( 'Billing address', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
			array(
				'tokenId'   => 'SHIPPING_ADDRESS',
				'tokenName' => esc_html_x( 'Shipping address', 'Woocommerce', 'uncanny-automator-pro' ),
				'tokenType' => 'text',
			),
		);

		return array_merge( $tokens, $custom_tokens );
	}
}
