<?php

namespace Uncanny_Automator_Pro\Integrations\WooCommerce_Bookings;

use Uncanny_Automator_Pro\Loop_Filters\WC_BOOKINGS_USER_PURCHASED_PRODUCT;
/**
 * Class Woocommerce_Bookings_Integration
 *
 * @package Uncanny_Automator_Pro
 */
class Woocommerce_Bookings_Integration extends \Uncanny_Automator\Integration {

	/**
	 * Setup Automator integration.
	 *
	 * @return void
	 */
	protected function setup() {
		if ( ! class_exists( '\Uncanny_Automator\Integrations\WooCommerce_Bookings\Wc_Bookings_Helpers' ) ) {
			return;
		}
		$this->helpers = new Wc_Bookings_Helpers_Pro();
		$this->set_integration( 'WC_BOOKINGS' );
		$this->set_name( 'Woo Bookings' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/woo-icon.svg' );
	}

	/**
	 * Load Integration Classes.
	 *
	 * @return void
	 */
	public function load() {
		// Load triggers
		new WC_BOOKINGS_BOOKING_STATUS_CHANGED( $this->helpers );
		new WC_BOOKINGS_ANON_BOOKING_UPDATED( $this->helpers );

		// Load actions
		new WC_BOOKINGS_CHANGE_BOOKING_STATUS( $this->helpers );
		new WC_BOOKINGS_CREATE_A_BOOKING( $this->helpers );

		// Load conditions
		$this->load_conditions();

		// Load loop filters
		new WC_BOOKINGS_USER_PURCHASED_PRODUCT();

		add_action( 'wp_ajax_select_all_product_resources', array( $this->helpers, 'select_all_product_resources' ) );
		add_action( 'wp_ajax_fetch_bookable_products', array( $this->helpers, 'fetch_bookable_products' ) );
	}

	/**
	 * Load condition classes.
	 *
	 * @return void
	 */
	private function load_conditions() {
		$conditions_dir = __DIR__ . '/conditions/';

		if ( ! is_dir( $conditions_dir ) ) {
			return;
		}

		$condition_files = glob( $conditions_dir . '*.php' );

		foreach ( $condition_files as $file ) {
			if ( is_file( $file ) ) {
				require_once $file;
			}
		}
	}

	/**
	 * Check if WooCommerce and WooCommerce Bookings Plugin is active.
	 *
	 * @return bool
	 */
	public function plugin_active() {
		return class_exists( 'WooCommerce' ) && class_exists( 'WC_Bookings' );
	}
}
