<?php

namespace Uncanny_Automator_Pro;

/**
 * Class UOA_ANON_WEBHOOKS
 */
class UOA_ANON_WEBHOOKS {

	/**
	 * Integration code
	 *
	 * @var string
	 */
	public static $integration = 'WEBHOOKS';

	/**
	 * Trigger code
	 *
	 * @var string
	 */
	private $trigger_code;

	/**
	 * Trigger meta
	 *
	 * @var string
	 */
	private $trigger_meta;

	/**
	 * Set up Automator trigger constructor.
	 */
	public function __construct() {
		if ( ! class_exists( '\Uncanny_Automator_Pro\Webhook_Rest_Handler' ) ) {
			return;
		}

		$this->trigger_code = 'WP_ANON_WEBHOOKS';
		$this->trigger_meta = 'WEBHOOKID'; //'WEBHOOK';
		Webhook_Rest_Handler::set_trigger_codes( $this->trigger_code );
		$this->define_trigger();
	}

	/**
	 * Define and register the trigger by pushing it into the Automator object
	 *
	 * @return void
	 */
	public function define_trigger() {

		$trigger = array(
			'author'              => Automator()->get_author_name( $this->trigger_code ),
			'support_link'        => Automator()->get_author_support_link( $this->trigger_code, 'knowledge-base/webhook-triggers/' ),
			'is_pro'              => true,
			'integration'         => self::$integration,
			'code'                => $this->trigger_code,
			'sentence'            => sprintf(
				// translators: %1$s Webhook text
				esc_html_x( 'Receive data from {{a webhook:%1$s}}', 'Webhooks', 'uncanny-automator-pro' ),
				'WEBHOOK_DATA'
			),
			'select_option_name'  => esc_html_x( 'Receive data from {{a webhook}}', 'Webhooks', 'uncanny-automator-pro' ),
			'action'              => 'automator_pro_run_webhook',
			'priority'            => 10,
			'accepted_args'       => 3,
			'type'                => 'anonymous',
			'validation_function' => array( $this, 'run_webhook' ),
			'options_group'       => Webhook_Common_Options::get_webhook_options_group( array( 'extract_headers' => true ) ),
			'buttons'             => Webhook_Common_Options::get_webhook_get_sample_button(),
			'inline_css'          => Webhook_Static_Content::inline_css(),
			'can_log_in_new_user' => false,
		);

		Automator()->register->trigger( $trigger );
	}

	/**
	 * Validation function when the trigger action is hit
	 *
	 * @param $param
	 * @param $recipe
	 * @param $request
	 *
	 * @return void
	 */
	public function run_webhook( $param, $recipe, $request ) {
		Webhook_Common_Options::run_webhook( $this->trigger_code, $this->trigger_meta, $param, $recipe, $request );
	}
}
