<?php

namespace Uncanny_Automator_Pro\Integrations\SureCart;

if ( automator_free_older_than( '5.6' ) ) {
	class SureCart_Pro_Tokens_New_Framework {};
} else {
	/**
	 * Class SureCart_Pro_Tokens_New_Framework
	 *
	 * @package Uncanny_Automator
	 */
	class SureCart_Pro_Tokens_New_Framework extends \Uncanny_Automator\Integrations\SureCart\SureCart_Tokens_New_Framework {
		/**
		 *
		 * @return array[] The list of tokens where array key is the token identifier.
		 */
		public function subscription_tokens() {

			$tokens = array(
				array(
					'tokenId'   => 'SUBSCRIPTION_ID',
					'tokenName' => esc_html_x( 'Subscription ID', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRICE_NAME',
					'tokenName' => esc_html_x( 'Subscription name', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRICE_ID',
					'tokenName' => esc_html_x( 'Subscription price ID', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRICE_AMOUNT',
					'tokenName' => esc_html_x( 'Subscription amount', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRICE_CURRENCY',
					'tokenName' => esc_html_x( 'Subscription price currency', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRICE_PERIOD',
					'tokenName' => esc_html_x( 'Subscription period', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_TAX',
					'tokenName' => esc_html_x( 'Subscription price tax included', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PAYMENT_METHOD',
					'tokenName' => esc_html_x( 'Subscription payment method', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRODUCT_NAME',
					'tokenName' => esc_html_x( 'Subscription product name', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
				array(
					'tokenId'   => 'SUBSCRIPTION_PRODUCT_IMAGE_URL',
					'tokenName' => esc_html_x( 'Subscription product image URL', 'Surecart', 'uncanny-automator' ),
					'tokenType' => 'text',
				),
			);

			return apply_filters( 'automator_surecart_subscription_tokens', $tokens );
		}

		/**
		 * hydrate_subscription_tokens
		 *
		 * @param  mixed $subscription
		 * @return array
		 */
		public function hydrate_subscription_tokens( $subscription_info ) {

			$billing_tokens = $this->hydrate_billing_tokens( $subscription_info->purchase->initial_order->checkout );

			return $billing_tokens + array(
				'SUBSCRIPTION_ID'                => $subscription_info->id,
				'SUBSCRIPTION_PRICE_NAME'        => $subscription_info->price->name,
				'SUBSCRIPTION_PRICE_ID'          => $subscription_info->price->id,
				'SUBSCRIPTION_PRICE_AMOUNT'      => $subscription_info->price->amount,
				'SUBSCRIPTION_PRICE_PERIOD'      => $subscription_info->price->recurring_interval,
				'SUBSCRIPTION_PRICE_CURRENCY'    => $subscription_info->price->currency,
				'SUBSCRIPTION_PAYMENT_METHOD'    => $subscription_info->payment_method->processor_type,
				'SUBSCRIPTION_TAX'               => $subscription_info->price->tax_enabled,
				'SUBSCRIPTION_PRODUCT_NAME'      => $subscription_info->purchase->product->name,
				'SUBSCRIPTION_PRODUCT_IMAGE_URL' => $subscription_info->purchase->product->image_url,
			);
		}
	}

}
