<?php

namespace Uncanny_Automator_Pro\Integrations\SureCart;

/**
 * Class SureCart_Integration
 *
 * @package Uncanny_Automator_Pro
 */
class SureCart_Integration extends \Uncanny_Automator\Integration {

	/**
	 * Integration Set-up.
	 */
	protected function setup() {
		$this->helpers = new SureCart_Pro_Helpers();
		$this->set_integration( 'SURECART' );
		$this->set_name( 'SureCart' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/surecart-icon.svg' );
	}

	/**
	 * Bootstrap actions, triggers, settings page, etc.
	 *
	 * @return void
	 */
	public function load() {
		// Triggers with dependencies - the Trigger abstract class DOES accept constructor parameters
		// The dependencies are passed to the parent constructor and used by get_item_helpers()
		new SURECART_ANON_ORDER_CONFIRMED( $this->helpers );
		new SURECART_ANON_PURCHASE_PRODUCT( $this->helpers );
		new SURECART_ANON_REFUND_ISSUED( $this->helpers );
		new SURECART_USERS_SUBSCRIPTION_CANCELLED( $this->helpers );
		new SURECART_USERS_SUBSCRIPTION_RENEWED( $this->helpers );

		// Add webhook events for order shipped, fulfilled, and subscription events
		add_filter( 'surecart/webhook_endpoint/set_attribute', array( $this, 'add_surecart_webhook_events' ), 10, 3 );
	}

	/**
	 * automator_free_requirement_met
	 *
	 * @return bool
	 */
	public function automator_free_requirement_met() {
		if ( ! defined( 'AUTOMATOR_PLUGIN_VERSION' ) || version_compare( AUTOMATOR_PLUGIN_VERSION, '4.5', '<' ) ) {
			return false;
		}
		return true;
	}

	/**
	 * Add custom webhook events to SureCart.
	 *
	 * @param mixed  $value The current value.
	 * @param string $key   The attribute key.
	 * @param mixed  $model The model object.
	 *
	 * @return mixed
	 */
	public function add_surecart_webhook_events( $value, $key, $model ) {
		if ( 'webhook_events' !== $key ) {
			return $value;
		}

		// Add custom webhook events
		if ( is_array( $value ) ) {
			$value[] = 'subscription.renewed';
			$value[] = 'subscription.canceled';
			$value[] = 'refund.succeeded';
			$value[] = 'purchase.created';
		}

		return $value;
	}

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @return bool
	 */
	public function plugin_active() {
		return defined( 'SURECART_PLUGIN_FILE' ) && $this->automator_free_requirement_met();
	}
}
