<?php
namespace Uncanny_Automator_Pro\Integrations\Run_Now;

/**
 * Class Run_Now_Migration
 *
 * @package Uncanny_Automator_Pro
 *
 * @since 5.1
 */
class Run_Now_Migration {

	/**
	 * Singleton instance.
	 *
	 * @var Run_Now_Migration|null
	 */
	private static $instance = null;

	/**
	 * Private constructor to prevent direct instantiation.
	 */
	private function __construct() {}

	/**
	 * Get singleton instance.
	 *
	 * @return Run_Now_Migration
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Run the migration to update integration code from Run_Now to RUN_NOW.
	 *
	 * @return void
	 */
	public function migrate_integration_code() {
		$migration_key = 'run_now_integration_code_migration';

		// Check if migration has already been run
		if ( $this->is_migration_completed( $migration_key ) ) {
			return;
		}

		global $wpdb;

		$wpdb->update(
			$wpdb->postmeta,
			array( 'meta_value' => 'RUN_NOW' ),
			array( 
				'meta_key'   => 'integration',
				'meta_value' => 'Run_Now'
			)
		);

		// Mark migration as completed
		$this->mark_migration_completed( $migration_key );
	}

	/**
	 * Check if migration has been completed.
	 *
	 * @param string $migration_key
	 * @return bool
	 */
	private function is_migration_completed( $migration_key ) {
		return '1' === automator_get_option( $migration_key );
	}

	/**
	 * Mark migration as completed.
	 *
	 * @param string $migration_key
	 * @return void
	 */
	private function mark_migration_completed( $migration_key ) {
		automator_add_option( $migration_key, '1' );
	}
}