<?php

namespace Uncanny_Automator_Pro;

use Groundhogg\Contact;
use Groundhogg\DB\Contacts;

/**
 * Class Groundhogg_Pro_Helpers
 *
 * @package Uncanny_Automator_Pro
 */
class Groundhogg_Pro_Helpers {

	/**
	 * @param $args
	 *
	 * @return array|mixed|void
	 */
	public function get_all_gh_contacts( $args = array() ) {


		$defaults = array(
			'option_code'           => 'GH_CONTACT',
			'label'                 => esc_attr__( 'Contact', 'uncanny-automator' ),
			'input_type'            => 'select',
			'required'              => true,
			'options_show_id'       => false,
			'is_any'                => false,
			'is_all'                => false,
			'supports_custom_value' => false,
			'relevant_tokens'       => array(),
			'options'               => array(),
		);

		$args         = wp_parse_args( $args, $defaults );
		$all_contacts = array();

		try {
			// Try using the get_db function first (simpler approach)
			if ( function_exists( '\Groundhogg\get_db' ) ) {
				$contacts_db = \Groundhogg\get_db( 'contacts' );
				$contacts = $contacts_db->query( array(
					'number'     => 1000,
					'offset'     => 0,
					'orderby'    => 'last_name',
					'order'      => 'ASC'
				) );
			} else {
				// Fallback to Contact_Query
				$query_args = array(
					'number'     => 1000,
					'offset'     => 0,
					'orderby'    => 'last_name',
					'order'      => 'ASC',
					'no_found_rows' => true
				);

				$contacts_db = new \Groundhogg\Contact_Query( $query_args );
				$contacts = $contacts_db->query( $query_args );
			}

		} catch ( \Error $e ) {
			// Keep $all_contacts as empty array
		} catch ( \Exception $e ) {
			// Keep $all_contacts as empty array
		}

		if ( ! empty( $contacts ) ) {
			foreach ( $contacts as $contact ) {
				// Handle both object and array formats
				$contact_id = is_object( $contact ) ? $contact->ID : $contact['ID'];
				$contact_email = is_object( $contact ) ? $contact->email : $contact['email'];
				
				if ( ! empty( $contact_email ) ) {
					$all_contacts[ $contact_id ] = $contact_email;
				}
			}
		}

		if ( true === $args['is_any'] ) {
			$all_contacts = array( '-1' => _x( 'Any contact', 'Groundhogg', 'uncanny-automator' ) ) + $all_contacts;
		}

		if ( true === $args['is_all'] ) {
			$all_contacts = array( '-1' => _x( 'All contacts', 'Groundhogg', 'uncanny-automator' ) ) + $all_contacts;
		}

		$args['options'] = $all_contacts;

		return apply_filters( 'uap_option_get_all_gh_contacts', $args );

	}

	/**
	 * Get all tags.
	 *
	 * @return array|mixed|void
	 */
	public static function get_tag_options() {

		$tags    = array();
		$options = array();

		try {
			if ( function_exists( '\Groundhogg\get_db' ) ) {
				$tags = \Groundhogg\get_db( 'tags' )->query( array() );
			} else {
				$tags = array();
			}
		} catch ( \Error $e ) {
			automator_log( $e->getMessage(), $tags, AUTOMATOR_DEBUG_MODE, 'groundhogg' );
		} catch ( \Exception $e ) {
			automator_log( $e->getMessage(), $tags, AUTOMATOR_DEBUG_MODE, 'groundhogg' );
		}

		if ( empty( $tags ) ) {
			return $options;
		}

		foreach ( $tags as $tag ) {
			$options[] = array(
				'value' => $tag->tag_id,
				'text'  => $tag->tag_name,
			);
		}

		return $options;
	}

}
