<?php

if ( ! defined( 'ABSPATH' ) ) {
	return;
}

// Check if all required Free classes exist before loading Pro classes
$required_free_classes = array(
	'Uncanny_Automator\Integrations\Github\Github_Integration',
	'Uncanny_Automator\Integrations\Github\Github_App_Helpers',
	'Uncanny_Automator\Integrations\Github\Github_Api_Caller',
	'Uncanny_Automator\Recipe\App_Trigger',
);

foreach ( $required_free_classes as $class ) {
	if ( ! class_exists( $class ) ) {
		return;
	}
}

// Check if the Pro class exists
if ( ! class_exists( 'Uncanny_Automator_Pro\Integrations\Github\Github_Pro_Integration' ) ) {
	return;
}

new Uncanny_Automator_Pro\Integrations\Github\Github_Pro_Integration();
