<?php

namespace Uncanny_Automator_Pro\Integrations\Github;

/**
 * Github Integration
 *
 * Extends the free version of the Github integration to include triggers.
 *
 * @package Uncanny_Automator_Pro\Integrations\Github
 */
class Github_Pro_Integration extends \Uncanny_Automator\Integrations\Github\Github_Integration {

	/**
	 * Setup the integration.
	 *
	 * @return void
	 */
	public function setup() {
		// Define helpers with Pro helpers using the same config values.
		$this->helpers = new Github_Pro_App_Helpers( self::get_config() );

		// Set the icon URL.
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/github-icon.svg' );

		// Finalize setup via the parent class with the common config.
		$this->setup_app_integration( self::get_config() );
	}

	/**
	 * Load Integration Classes.
	 *
	 * @return void
	 */
	public function load() {
		// Load settings page with dependencies.
		new Github_Pro_Settings(
			$this->dependencies,
			$this->get_settings_config()
		);

		// Load triggers with dependencies.
		new EVENT_OCCURS_IN_REPO( $this->dependencies );
		new ISSUE_CREATED_IN_REPO( $this->dependencies );
		new PULL_REQUEST_MERGED_IN_REPO( $this->dependencies );
		new PULL_REQUEST_OPENED_IN_REPO( $this->dependencies );
		new PUSH_TO_REPO( $this->dependencies );
		new RELEASE_CREATED_IN_REPO( $this->dependencies );
	}

	/**
	 * Register hooks.
	 *
	 * @return void
	 */
	public function register_hooks() {
		// Recipe options AJAX handlers.
		add_action( 'wp_ajax_automator_github_get_event_action_options', array( $this->helpers, 'get_event_action_options_ajax' ) );

		// Dynamic tokens filter.
		add_filter(
			'automator_maybe_trigger_github_event_occurs_in_repo_tokens',
			array( EVENT_OCCURS_IN_REPO::class, 'maybe_add_conditional_tokens' ),
			20,
			2
		);
	}
}
