<?php

namespace Uncanny_Automator_Pro;

/**
 * Class ET_ANON_TOKENS
 *
 * @package Uncanny_Automator_Pro
 */
class ET_ANON_TOKENS {


	/**
	 *
	 */
	public function __construct() {
		add_filter(
			'automator_maybe_trigger_ec_attendeeregistered_tokens',
			array(
				$this,
				'et_anonattendee_possible_tokens',
			),
			20,
			2
		);

		add_action( 'automator_before_trigger_completed', array( $this, 'save_token_data' ), 20, 2 );
		add_filter(
			'automator_maybe_trigger_ec_registeredwithwc_tokens',
			array(
				$this,
				'ec_wc_possible_tokens',
			),
			20,
			2
		);

		add_filter( 'automator_maybe_parse_token', array( $this, 'et_anonattendee_tokens' ), 200, 6 );
	}

	/**
	 * @param $tokens
	 * @param $args
	 *
	 * @return array|mixed
	 */
	public function et_anonattendee_possible_tokens( $tokens = array(), $args = array() ) {

		if ( ! automator_pro_do_identify_tokens() ) {
			return $tokens;
		}

		$trigger_meta = $args['meta'];
		$event_id     = $args['triggers_meta']['ANONATTENDEE'];

		if ( empty( $event_id ) ) {
			return $tokens;
		}

		if ( intval( '-1' ) === intval( $event_id ) ) {
			return array_merge( $tokens, $this->get_basic_tokens( $trigger_meta ) );
		}

		if ( ! class_exists( '\Tribe__Tickets__Tickets' ) || ! method_exists( '\Tribe__Tickets__Tickets', 'get_all_event_tickets' ) ) {
			return $tokens;
		}

		$tickets = \Tribe__Tickets__Tickets::get_all_event_tickets( $event_id );

		if ( ! class_exists( '\Tribe__Tickets_Plus__Meta' ) || ! method_exists( '\Tribe__Tickets_Plus__Meta', 'get_attendee_meta_fields' ) ) {
			return $tokens;
		}

		if ( empty( $tickets ) ) {
			return array_merge( $tokens, $this->get_basic_tokens( $trigger_meta ) );
		}

		foreach ( $tickets as $ticket ) {
			$ticket_id   = $ticket->ID;
			$ticket_name = $ticket->name;
			$new_tokens  = $this->get_ticket_fields_token( $ticket_id, $ticket_name, $trigger_meta );
			$tokens      = array_merge( $tokens, $new_tokens );
		}

		return $tokens;
	}

	/**
	 * save_token_data
	 *
	 * @param mixed $args
	 * @param mixed $trigger
	 *
	 * @return void
	 */
	public function save_token_data( $args, $trigger ) {
		if ( ! isset( $args['trigger_args'] ) || ! isset( $args['entry_args']['code'] ) ) {
			return;
		}

		if ( in_array( 'REGISTEREDWITHWC', $args['entry_args'], true ) ) {
			list ( $attendee, $attendee_data, $ticket, $__this ) = $args['trigger_args'];
			$trigger_log_entry                                   = $args['trigger_entry'];
			if ( ! empty( $attendee ) ) {
				Automator()->db->token->save( 'attendee_id', $attendee->ID, $trigger_log_entry );
				Automator()->db->token->save( 'attendee_data', maybe_serialize( $attendee_data ), $trigger_log_entry );
			}
		}
	}

	/**
	 * @param $tokens
	 * @param $args
	 *
	 * @return array|array[]
	 */
	public function ec_wc_possible_tokens( $tokens = array(), $args = array() ) {
		$trigger_code = $args['triggers_meta']['code'];

		$event_id = isset( $args['triggers_meta']['ECEVENTS'] ) ? $args['triggers_meta']['ECEVENTS'] : '-1';

		$fields = array(
			array(
				'tokenId'         => 'TICKET_NAME',
				'tokenName'       => esc_html_x( 'Ticket name', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'ORDER_ID',
				'tokenName'       => esc_html_x( 'Order ID', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'ORDER_STATUS',
				'tokenName'       => esc_html_x( 'Order status', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'ORDER_PAYMENT_METHOD',
				'tokenName'       => esc_html_x( 'Payment method', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'ORDER_TOTAL',
				'tokenName'       => esc_html_x( 'Order total', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_FIRST_NAME',
				'tokenName'       => esc_html_x( 'Billing first name', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_LAST_NAME',
				'tokenName'       => esc_html_x( 'Billing last name', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_COMPANY',
				'tokenName'       => esc_html_x( 'Billing company', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_COUNTRY',
				'tokenName'       => esc_html_x( 'Billing country', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_ADDRESS_1',
				'tokenName'       => esc_html_x( 'Billing address line 1', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_ADDRESS_2',
				'tokenName'       => esc_html_x( 'Billing address line 2', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_CITY',
				'tokenName'       => esc_html_x( 'Billing city', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_STATE',
				'tokenName'       => esc_html_x( 'Billing state', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_POSTCODE',
				'tokenName'       => esc_html_x( 'Billing postcode', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_PHONE',
				'tokenName'       => esc_html_x( 'Billing phone', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_code,
			),
			array(
				'tokenId'         => 'BILLING_EMAIL',
				'tokenName'       => esc_html_x( 'Billing email', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'email',
				'tokenIdentifier' => $trigger_code,
			),
		);

		if ( intval( '-1' ) === intval( $event_id ) ) {
			$basic_tokens = $this->get_basic_tokens( $trigger_code );
			$fields       = array_merge( $basic_tokens, $fields );
		}

		$final_tokens = array_merge( $tokens, $fields );

		return Automator()->utilities->remove_duplicate_token_ids( $final_tokens );
	}

	/**
	 * @param $value
	 * @param $pieces
	 * @param $recipe_id
	 * @param $trigger_data
	 * @param $user_id
	 * @param $replace_args
	 *
	 * @return false|float|int|mixed|string|\WP_Error
	 */
	public function et_anonattendee_tokens( $value, $pieces, $recipe_id, $trigger_data, $user_id, $replace_args ) {

		if ( empty( $pieces ) || empty( $trigger_data ) || empty( $replace_args ) ) {
			return $value;
		}

		if ( in_array( 'ATTENDEEREGISTERED', $pieces, true ) ) {
			$event_id = Automator()->db->token->get( 'event_id', $replace_args );
			$event    = get_post( $event_id );

			if ( preg_match( '/\|/', $pieces[2] ) ) {
				$token_info = explode( '|', $pieces[2] );
				$to_replace = isset( $token_info[1] ) ? $token_info[1] : '';
			} else {
				$to_replace = $pieces[2];
			}

			if ( ! $event instanceof \WP_Post ) {
				return $value;
			}

			// Saved in the trigger completed action
			$event_product_id = Automator()->db->token->get( 'event_product_id', $replace_args );

			/**
			 * token_info
			 * example:
					(
						[0] => 99384 // event product id
						[1] => tribe-tickets-plus-iac-name
					)
			 */

			switch ( $to_replace ) {
				case 'ANONATTENDEE':
					$value = esc_html( $event->post_title );
					break;
				case 'ANONATTENDEE_ID':
					$value = $event->ID;
					break;
				case 'ANONATTENDEE_URL':
					$value = get_permalink( $event->ID );
					break;
				case 'ANONATTENDEE_THUMB_ID':
					$value = get_post_thumbnail_id( $event->ID );
					break;
				case 'ANONATTENDEE_THUMB_URL':
					$value = get_the_post_thumbnail_url( $event->ID );
					break;
				case 'holder_name':
				case 'tribe-tickets-plus-iac-name':
					$value = '';
					if( isset( $token_info[0] ) && absint( $token_info[0] ) === absint( $event_product_id ) ) {
						$value = Automator()->db->token->get( 'holder_name', $replace_args );
						$value = maybe_unserialize( $value );
						break;
					}
					break;
				case 'holder_email':
				case 'tribe-tickets-plus-iac-email':
					$value = '';
					if( isset( $token_info[0] ) && absint( $token_info[0] ) === absint( $event_product_id ) ) {
						$value = Automator()->db->token->get( 'holder_email', $replace_args );
						$value = maybe_unserialize( $value );
						break;
					}
					break;
				default:
					$value    = '';
					$attendee = maybe_unserialize( Automator()->db->token->get( 'attendee', $replace_args ) );
					if ( isset( $attendee['attendee_meta'] ) && isset( $attendee['attendee_meta'][ $to_replace ] ) ) {
						$value = $attendee['attendee_meta'][ $to_replace ];
					}
					break;
			}
		}

		if ( in_array( 'REGISTEREDWITHWC', $pieces, true ) ) {

			$to_replace    = $pieces[2];
			$attendee_data = Automator()->db->token->get( 'attendee_data', $replace_args );
			if ( empty( $attendee_data ) ) {
				return $value;
			}
			$event_id = $attendee_data['post_id'];
			$event    = get_post( $event_id );

			if ( ! $event instanceof \WP_Post ) {
				return $value;
			}
			$order_id = $attendee_data['order_id'];
			$order    = wc_get_order( $order_id );
			switch ( $to_replace ) {
				case 'ECEVENTS':
					$value = esc_html( $event->post_title );
					break;
				case 'ECEVENTS_URL':
					$value = get_permalink( $event->ID );
					break;
				case 'ECEVENTS_THUMB_ID':
					$value = get_post_thumbnail_id( $event->ID );
					break;
				case 'ECEVENTS_THUMB_URL':
					$value = get_the_post_thumbnail_url( $event->ID );
					break;
				case 'TICKET_NAME':
					$ticket_id = $attendee_data['ticket_id'];
					try {
						// Attempt to get the ticket provider class.
						$ticket_provider_class = (string) \Tribe__Tickets__Tickets::get_event_ticket_provider( $ticket_id );
						$ticket_provider       = new $ticket_provider_class();
						$ticket                = $ticket_provider->get_ticket( $event_id, $ticket_id );
						$value                 = $ticket->name;

					} catch ( \Exception $e ) {
						// Just get the post
						$ticket = get_post( $ticket_id );
						$value  = $ticket->post_title;
					}
					break;
				case 'ORDER_ID':
					$value = $order_id;

					break;
				case 'ORDER_STATUS':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_status();
					}
					break;
				case 'ORDER_PAYMENT_METHOD':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_payment_method_title();
					}
					break;
				case 'ORDER_TOTAL':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_total();
					}
					break;
				case 'BILLING_FIRST_NAME':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_first_name();
					}
					break;
				case 'BILLING_LAST_NAME':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_last_name();
					}
					break;
				case 'BILLING_EMAIL':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_email();
					}
					break;
				case 'BILLING_PHONE':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_phone();
					}
					break;
				case 'BILLING_COMPANY':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_company();
					}
					break;
				case 'BILLING_COUNTRY':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_country();
					}
					break;
				case 'BILLING_ADDRESS_1':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_address_1();
					}
					break;
				case 'BILLING_ADDRESS_2':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_address_2();
					}
					break;
				case 'BILLING_CITY':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_city();
					}
					break;
				case 'BILLING_STATE':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_state();
					}
					break;
				case 'BILLING_POSTCODE':
					if ( $order instanceof \WC_Order ) {
						$value = $order->get_billing_postcode();
					}
					break;
				case 'holder_name':
					$value = $attendee_data['full_name'];
					break;
				case 'holder_email':
					$value = $attendee_data['email'];
					break;
				case 'ECEVENTS_ID':
					$value = $attendee_data['post_id'];
					break;
			}
		}

		return $value;
	}

	/**
	 * @param $ticket_id
	 * @param $ticket_name
	 * @param $trigger_meta
	 *
	 * @return array[]
	 */
	public function get_ticket_fields_token( $ticket_id, $ticket_name, $trigger_meta ) {
		$tokens = array(
			array(
				'tokenId'         => sprintf( '%d|tribe-tickets-plus-iac-name', $ticket_id ),
				'tokenName'       => sprintf( '%s &mdash; Attendee name', $ticket_name ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $trigger_meta,
			),
			array(
				'tokenId'         => sprintf( '%d|tribe-tickets-plus-iac-email', $ticket_id ),
				'tokenName'       => sprintf( '%s &mdash; Attendee email', $ticket_name ),
				'tokenType'       => 'email',
				'tokenIdentifier' => $trigger_meta,
			),
		);

		$meta = \Tribe__Tickets_Plus__Meta::get_attendee_meta_fields( $ticket_id );
		if ( ! empty( $meta ) ) {
			foreach ( $meta as $fields ) {
				switch ( $fields['type'] ) {
					case 'email':
						$type = 'email';
						break;
					case 'number':
						$type = 'int';
						break;
					default:
						$type = 'text';
						break;
				}

				$tokens[] = array(
					'tokenId'         => sprintf( '%d|%s', $ticket_id, $fields['slug'] ),
					'tokenName'       => sprintf( '%s &mdash; %s', $ticket_name, $fields['label'] ),
					'tokenType'       => $type,
					'tokenIdentifier' => $trigger_meta,
				);
			}
		}

		return $tokens;
	}
	/**
	 * Get basic tokens.
	 *
	 * @param mixed $token_identifier The ID.
	 * @return mixed
	 */
	public function get_basic_tokens( $token_identifier ) {
		return array(
			array(
				'tokenId'         => 'holder_name',
				'tokenName'       => esc_html_x( 'Attendee name', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'text',
				'tokenIdentifier' => $token_identifier,
			),
			array(
				'tokenId'         => 'holder_email',
				'tokenName'       => esc_html_x( 'Attendee email', 'Event Tickets', 'uncanny-automator-pro' ),
				'tokenType'       => 'email',
				'tokenIdentifier' => $token_identifier,
			),
		);
	}
}
