<?php


namespace Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads;

use Uncanny_Automator\Integrations\Easy_Digital_Downloads\Edd_Helpers;

/**
 * Class Edd_Pro_Helpers
 *
 * @package Uncanny_Automator_Pro
 */
class Edd_Pro_Helpers extends Edd_Helpers {



	/**
	 * All EDD discount codes.
	 *
	 * @param string $label
	 * @param string $option_code
	 *
	 * @return mixed
	 */
	public function all_edd_discount_codes( $label = null, $option_code = 'EDDDISCOUNTCODES', $any_option = true ) {
		if ( ! $label ) {
			$label = esc_attr_x( 'Discount code', 'Edd', 'uncanny-automator' );
		}

		$all_discount_codes = array();

		if ( true === $any_option ) {
			$all_discount_codes[] = array(
				'text'  => esc_attr_x( 'Any discount code', 'Edd', 'uncanny-automator' ),
				'value' => '-1',
			);
		}

		$discounts = edd_get_discounts();

		if ( isset( $discounts ) && ! empty( $discounts ) ) {
			foreach ( $discounts as $discount ) {
				$title = $discount->post_title;
				// set up a descriptive title for posts with no title.
				if ( empty( $title ) ) {
					/* translators: ID of recipe, trigger or action  */
					$title = sprintf( esc_attr_x( 'ID: %1$s (no title)', 'Edd', 'uncanny-automator' ), $discount->ID );
				}
				// add post as an option.
				$all_discount_codes[] = array(
					'text'  => $title,
					'value' => $discount->ID,
				);
			}
		}

		$option = array(
			'option_code'     => $option_code,
			'label'           => $label,
			'input_type'      => 'select',
			'required'        => true,
			// to setup example, lets define the value the child will be based on
			'current_value'   => false,
			'validation_type' => 'text',
			'options'         => $all_discount_codes,
			'relevant_tokens' => array(),
		);

		return apply_filters( 'uap_option_all_edd_discount_codes', $option );
	}

	/**
	 * less_greater_options
	 *
	 * @return array
	 */
	public function less_greater_options() {

		$amount_conditions = Automator()->helpers->recipe->field->less_or_greater_than();
		$options           = array();
		foreach ( $amount_conditions['options'] as $value => $text ) {
			$options[] = array(
				'text'  => $text,
				'value' => $value,
			);
		}

		return $options;
	}

	/**
	 * All EDD downloads options (not required, no tokens).
	 *
	 * @param string $label
	 * @param string $option_code
	 *
	 * @return mixed
	 */
	public function all_edd_downloads_not_required( $label = null, $option_code = 'EDDPRODUCTS', $any_option = true, $is_recurring = false ) {

		if ( ! $label ) {
			$label = esc_html_x( 'Download', 'Easy Digital Downloads', 'uncanny-automator' );
		}

		$args = array(
			'post_type'      => 'download',
			'posts_per_page' => 9999, //phpcs:ignore WordPress.WP.PostsPerPage.posts_per_page_posts_per_page
			'orderby'        => 'title',
			'order'          => 'ASC',
			'post_status'    => 'publish',
		);

		$downloads = get_posts( $args );

		$all_downloads = array();

		if ( $any_option ) {
			$all_downloads[] = array(
				'text'  => esc_html_x( 'Any download', 'Easy Digital Downloads', 'uncanny-automator' ),
				'value' => '-1',
			);
		}

		if ( $downloads ) {
			foreach ( $downloads as $download ) {
				$download_id = $download->ID;

				// Just list everything
				if ( ! $is_recurring ) {
					$all_downloads[] = array(
						'text'  => $download->post_title,
						'value' => $download_id,
					);
					continue;
				}

				// Check if the product has a recurring option
				if ( edd_recurring()->is_recurring( $download_id ) ) {
					$all_downloads[] = array(
						'text'  => $download->post_title,
						'value' => $download_id,
					);
					continue;
				}

				if ( ! edd_has_variable_prices( $download_id ) ) {
					continue;
				}

				$variable_prices = edd_get_variable_prices( $download_id );

				if ( $variable_prices ) {
					foreach ( $variable_prices as $price ) {
						if ( ! isset( $price['recurring'] ) || 'yes' !== $price['recurring'] ) {
							continue;
						}
						$all_downloads[] = array(
							'text'  => $download->post_title,
							'value' => $download_id,
						);
					}
				}
			}
		}

		$option = array(
			'option_code'     => $option_code,
			'label'           => $label,
			'input_type'      => 'select',
			'required'        => false,
			'options'         => $all_downloads,
			'relevant_tokens' => array(), // empty
		);

		return apply_filters( 'uap_option_all_edd_downloads_simple', $option );
	}
}
