<?php

namespace Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads;

/**
 * Class Edd_Integration
 *
 * @package Uncanny_Automator_Pro
 */
class Edd_Integration extends \Uncanny_Automator\Integration {

	/**
	 * Integration Set-up.
	 */
	protected function setup() {
		$this->helpers = new Edd_Pro_Helpers();
		$this->set_integration( 'EDD' );
		$this->set_name( 'Easy Digital Downloads' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/easy-digital-downloads-icon.svg' );
	}
	/**
	 * Load.
	 */
	public function load() {
		//actions
		new EDD_DELETE_CUSTOMER_BY_ID( $this->helpers );
		new EDD_DELETE_CUSTOMER( $this->helpers );
		new EDD_GENERATE_DISCOUNT_CODE( $this->helpers );

		//triggers
		new EDD_ANON_FILE_DOWNLOADED( $this->helpers );
		new EDD_PAYMENT_FAILS( $this->helpers );
		new EDD_PRODPURCHWITHDISCOUNTCODE( $this->helpers );
		new EDD_USER_LIFETIME_VALUE( $this->helpers );

		//conditions
		new \Uncanny_Automator_Pro\EDD_USER_DOWNLOADED_FILE();
		new \Uncanny_Automator_Pro\EDD_USER_HAS_PURCHASED_DOWNLOAD();
	}

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @return bool
	 */
	public function plugin_active() {

		// Check if Automator plugin version is 6.8.0 or higher.
		$is_dependency_ready = version_compare( AUTOMATOR_PLUGIN_VERSION, '6.8.0', '>=' );

		return function_exists( 'EDD' ) && $is_dependency_ready;
	}
}
