<?php

namespace Uncanny_Automator_Pro\Integrations\Easy_Digital_Downloads;

/**
 * Class EDD_DELETE_CUSTOMER_BY_ID
 *
 * @package Uncanny_Automator_Pro
 */
class EDD_DELETE_CUSTOMER_BY_ID extends \Uncanny_Automator\Recipe\Action {

	/**
	 * @return mixed|void
	 */
	protected function setup_action() {
		$this->set_integration( 'EDD' );
		$this->set_action_code( 'EDD_DELETE_CUSTOMER_BY_ID' );
		$this->set_action_meta( 'EDD_CUSTOMER' );
		$this->set_is_pro( true );
		$this->set_requires_user( false );
		$this->set_sentence(
			sprintf(
			// translators: %1$s: Customer ID
				esc_html_x( 'Delete a customer that matches {{a customer ID:%1$s}}', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				$this->get_action_meta(),
				'EXPIRATION_DATE:' . $this->get_action_meta()
			)
		);
		$this->set_readable_sentence( esc_html_x( 'Delete a customer by {{ID}}', 'Easy Digital Downloads', 'uncanny-automator-pro' ) );
	}

	/**
	 * Define the Action's options
	 *
	 * @return void
	 */
	public function options() {

		return array(
			Automator()->helpers->recipe->field->text(
				array(
					'option_code'     => $this->get_action_meta(),
					'input_type'      => 'int',
					'label'           => esc_html_x( 'Customer ID', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
					'description'     => esc_html_x( 'Warning: Deleting a customer deletes all associated history (orders, subscriptions, notes, etc.)', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
					'relevant_tokens' => array(),
				)
			),
		);
	}

	/**
	 * @return array[]
	 */
	public function define_tokens() {
		return array(
			'CUSTOMER_EMAIL' => array(
				'name' => esc_html_x( 'Customer email(s)', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
				'type' => 'email',
			),
		);
	}

	/**
	 * @param int   $user_id
	 * @param array $action_data
	 * @param int   $recipe_id
	 * @param array $args
	 * @param       $parsed
	 */
	protected function process_action( $user_id, $action_data, $recipe_id, $args, $parsed ) {
		$customer_id = sanitize_text_field( $parsed[ $this->get_action_meta() ] );
		if ( empty( $customer_id ) ) {
			$this->add_log_error( esc_html_x( 'Please enter a customer ID.', 'Easy Digital Downloads', 'uncanny-automator-pro' ) );

			return false;
		}

		$customer_data = edd_get_customer( $customer_id );
		if ( empty( $customer_data ) ) {
			$this->add_log_error(
				sprintf(
					// translators: %1$s: Customer ID
					esc_html_x( 'Customer %1$s not found.', 'Easy Digital Downloads', 'uncanny-automator-pro' ),
					$customer_id
				)
			);

			return false;
		}

		$customer_deleted = edd_delete_customer( $customer_data->id );
		if ( 1 !== $customer_deleted ) {
			$this->add_log_error( $customer_deleted );

			return false;
		}

		$this->hydrate_tokens(
			array(
				'CUSTOMER_EMAIL' => $customer_data->email,
			)
		);

		return true;
	}
}
