<?php

namespace Uncanny_Automator_Pro\Integrations\Edd_Recurring_Integration;

/**
 * Class Edd_Recurring_Integration
 *
 * @package Uncanny_Automator_Pro\Integrations\Edd_Recurring_Integration
 */
class Edd_Recurring_Integration extends \Uncanny_Automator\Integration {

	/**
	 * Integration Set-up.
	 */
	protected function setup() {
		$this->helpers = new Edd_Recurring_Pro_Helpers();
		$this->set_integration( 'EDD_RECURRING' );
		$this->set_name( 'EDD - Recurring Payments' );
		$this->set_icon_url( plugin_dir_url( __FILE__ ) . 'img/easy-digital-downloads-icon.svg' );
	}
	/**
	 * Load.
	 */
	public function load() {
		//actions
		new EDD_CANCEL_SUBSCRIPTION_BY_ID( $this->helpers );
		new EDD_SET_SUBSCRIPTION_EXPIRATION_DATE( $this->helpers );

		//triggers
		new EDD_USER_CANCELS_SUBSCRIPTION( $this->helpers );
		new EDD_USER_SUBSCRIPTION_EXPIRES( $this->helpers );
		new EDD_USER_SUBSCRIBE_PRODWITHPRICEOPTION( $this->helpers );
		new EDD_USER_REFUND_PRODWITHPRICEOPTION( $this->helpers );
		new EDD_USER_CANCELS_SUBSCRIPTION_PRODWITHPRICEOPTION( $this->helpers );
		new EDD_USER_SUBSCRIPTION_EXPIRES_PRODWITHPRICEOPTION( $this->helpers );
		new EDD_USER_SUBSCRIPTION_RENEWED_PRODWITHPRICEOPTION( $this->helpers );
		new EDD_USER_SUBSCRIPTION_RENEWED( $this->helpers );

		//conditions
		new EDD_USER_DOES_NOT_HAVE_ACTIVE_SUBSCRIPTION();
		new EDD_USER_HAS_ACTIVE_SUBSCRIPTION();
	}

	/**
	 * Only load this integration and its triggers and actions if the related plugin is active
	 *
	 * @return bool
	 */
	public function plugin_active() {

		return function_exists( 'EDD' ) && class_exists( 'EDD_Recurring' );
	}
}
