<?php

if ( ! defined( 'ABSPATH' ) ) {
	return;
}

// Check if all required Free classes exist before loading Pro classes
$required_free_classes = array(
	'Uncanny_Automator\Integrations\Asana\Asana_Integration',
	'Uncanny_Automator\Integrations\Asana\Asana_App_Helpers',
	'Uncanny_Automator\Integrations\Asana\Asana_Api_Caller',
);

foreach ( $required_free_classes as $class ) {
	if ( ! class_exists( $class ) ) {
		return;
	}
}

// Check if the Pro class exists
if ( ! class_exists( 'Uncanny_Automator_Pro\Integrations\Asana\Asana_Pro_Integration' ) ) {
	return;
}

new Uncanny_Automator_Pro\Integrations\Asana\Asana_Pro_Integration();
