<?php

namespace Uncanny_Automator_Pro\Settings;

use Uncanny_Automator\Settings\Premium_Integration_Templating_Helpers;

/**
 * Trait for Pro integration templating that hooks into free templating
 *
 * This trait provides empty methods that Pro settings can override to
 * hook into the free templating system without duplicating functionality.
 *
 * @package Uncanny_Automator_Pro\Settings
 */
trait Pro_Integration_Templating {

	use Premium_Integration_Templating_Helpers;

	/**
	 * Register Pro templating hooks
	 *
	 * @return void
	 */
	protected function register_pro_templating_hooks() {
		$integration_id = $this->get_id();
		$status_key     = $this->get_hook_status_key();

		// Before panel
		add_action(
			"automator_app_settings_{$integration_id}_before_{$status_key}_panel",
			array( $this, "output_before_{$status_key}_panel" ),
			10
		);

		// After panel
		add_action(
			"automator_app_settings_{$integration_id}_after_{$status_key}_panel",
			array( $this, "output_after_{$status_key}_panel" ),
			10
		);

		// Before panel content
		add_action(
			"automator_app_settings_{$integration_id}_before_{$status_key}_panel_content",
			array( $this, "output_before_{$status_key}_panel_content" ),
			10
		);

		// After panel content
		add_action(
			"automator_app_settings_{$integration_id}_after_{$status_key}_panel_content",
			array( $this, "output_after_{$status_key}_panel_content" ),
			10
		);

		// Before panel bottom
		add_action(
			"automator_app_settings_{$integration_id}_before_{$status_key}_panel_bottom",
			array( $this, "output_before_{$status_key}_panel_bottom" ),
			10
		);

		// After panel bottom
		add_action(
			"automator_app_settings_{$integration_id}_after_{$status_key}_panel_bottom",
			array( $this, "output_after_{$status_key}_panel_bottom" ),
			10
		);

		// Before panel bottom left
		add_action(
			"automator_app_settings_{$integration_id}_before_{$status_key}_panel_bottom_left",
			array( $this, "output_before_{$status_key}_panel_bottom_left" ),
			10
		);

		// After panel bottom left
		add_action(
			"automator_app_settings_{$integration_id}_after_{$status_key}_panel_bottom_left",
			array( $this, "output_after_{$status_key}_panel_bottom_left" ),
			10
		);

		// Before panel bottom right
		add_action(
			"automator_app_settings_{$integration_id}_before_{$status_key}_panel_bottom_right",
			array( $this, "output_before_{$status_key}_panel_bottom_right" ),
			10
		);

		// After panel bottom right
		add_action(
			"automator_app_settings_{$integration_id}_after_{$status_key}_panel_bottom_right",
			array( $this, "output_after_{$status_key}_panel_bottom_right" ),
			10
		);
	}

	/**
	 * Output content before the connected panel
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_connected_panel() {}

	/**
	 * Output content after the connected panel
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_connected_panel() {}

	/**
	 * Output content before the connected panel content
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_connected_panel_content() {}

	/**
	 * Output content after the connected panel content
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_connected_panel_content() {}

	/**
	 * Output content before the connected panel bottom
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_connected_panel_bottom() {}

	/**
	 * Output content after the connected panel bottom
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_connected_panel_bottom() {}

	/**
	 * Output content before the connected panel bottom left
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_connected_panel_bottom_left() {}

	/**
	 * Output content after the connected panel bottom left
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_connected_panel_bottom_left() {}

	/**
	 * Output content before the connected panel bottom right
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_connected_panel_bottom_right() {}

	/**
	 * Output content after the connected panel bottom right
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_connected_panel_bottom_right() {}

	/**
	 * Output content before the disconnected panel
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_disconnected_panel() {}

	/**
	 * Output content after the disconnected panel
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_disconnected_panel() {}

	/**
	 * Output content before the disconnected panel content
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_disconnected_panel_content() {}

	/**
	 * Output content after the disconnected panel content
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_disconnected_panel_content() {}

	/**
	 * Output content before the disconnected panel bottom
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_disconnected_panel_bottom() {}

	/**
	 * Output content after the disconnected panel bottom
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_disconnected_panel_bottom() {}

	/**
	 * Output content before the disconnected panel bottom left
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_disconnected_panel_bottom_left() {}

	/**
	 * Output content after the disconnected panel bottom left
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_disconnected_panel_bottom_left() {}

	/**
	 * Output content before the disconnected panel bottom right
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_before_disconnected_panel_bottom_right() {}

	/**
	 * Output content after the disconnected panel bottom right
	 * Override this method in extending classes to add content
	 *
	 * @return void
	 */
	public function output_after_disconnected_panel_bottom_right() {}
}
