<?php
namespace Uncanny_Automator_Pro\Settings;

use Uncanny_Automator\Settings\Premium_Integration_Items;

/**
 * Trait for discovering available actions and triggers in pro integrations
 *
 * @package Uncanny_Automator_Pro\Settings
 */
trait Pro_Premium_Integration_Items {

	use Premium_Integration_Items;

	/**
	 * Get the full path to the items directory
	 *
	 * @param string $type Either 'actions' or 'triggers'
	 * @return string
	 */
	protected function get_items_directory( string $type ): string {
		// Get the current class's directory
		$reflection = new \ReflectionClass( get_class( $this ) );
		$dir        = dirname( $reflection->getFileName() );

		// Go up one level and into type directory
		return dirname( $dir ) . '/' . $type;
	}
}
