<?php
/**
 * View: Sparkle Icon.
 *
 * @since 4.21.0
 * @version 4.21.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__sparkle' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Sparkle icon', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 8,
		'label'   => $label,
		'width'   => 8,
	],
);
?>

<g id="sparkle">
	<path id="Vector" d="M2.66667 4.33333C2.66667 3.89131 2.84226 3.46738 3.15482 3.15482C3.46738 2.84226 3.89131 2.66667 4.33333 2.66667C4.42174 2.66667 4.50652 2.63155 4.56904 2.56904C4.63155 2.50652 4.66667 2.42174 4.66667 2.33333C4.66667 2.24493 4.63155 2.16014 4.56904 2.09763C4.50652 2.03512 4.42174 2 4.33333 2C3.89131 2 3.46738 1.82441 3.15482 1.51184C2.84226 1.19928 2.66667 0.775361 2.66667 0.333333C2.66667 0.244928 2.63155 0.160143 2.56904 0.0976311C2.50652 0.035119 2.42174 0 2.33333 0C2.24493 0 2.16014 0.035119 2.09763 0.0976311C2.03512 0.160143 2 0.244928 2 0.333333C2 0.775361 1.82441 1.19928 1.51184 1.51184C1.19928 1.82441 0.775361 2 0.333333 2C0.244928 2 0.160143 2.03512 0.0976311 2.09763C0.035119 2.16014 0 2.24493 0 2.33333C0 2.42174 0.035119 2.50652 0.0976311 2.56904C0.160143 2.63155 0.244928 2.66667 0.333333 2.66667C0.775361 2.66667 1.19928 2.84226 1.51184 3.15482C1.82441 3.46738 2 3.89131 2 4.33333C2 4.42174 2.03512 4.50652 2.09763 4.56904C2.16014 4.63155 2.24493 4.66667 2.33333 4.66667C2.42174 4.66667 2.50652 4.63155 2.56904 4.56904C2.63155 4.50652 2.66667 4.42174 2.66667 4.33333Z" fill="currentColor"/>
	<path id="Vector_2" d="M4.66666 6.33337C4.48985 6.33337 4.32028 6.26314 4.19526 6.13811C4.07023 6.01309 3.99999 5.84352 3.99999 5.66671C3.99999 5.5783 3.96488 5.49352 3.90236 5.431C3.83985 5.36849 3.75507 5.33337 3.66666 5.33337C3.57826 5.33337 3.49347 5.36849 3.43096 5.431C3.36845 5.49352 3.33333 5.5783 3.33333 5.66671C3.33333 5.84352 3.26309 6.01309 3.13807 6.13811C3.01304 6.26314 2.84347 6.33337 2.66666 6.33337C2.57826 6.33337 2.49347 6.36849 2.43096 6.431C2.36845 6.49352 2.33333 6.5783 2.33333 6.66671C2.33333 6.75511 2.36845 6.8399 2.43096 6.90241C2.49347 6.96492 2.57826 7.00004 2.66666 7.00004C2.84347 7.00004 3.01304 7.07028 3.13807 7.1953C3.26309 7.32033 3.33333 7.4899 3.33333 7.66671C3.33333 7.75511 3.36845 7.8399 3.43096 7.90241C3.49347 7.96492 3.57826 8.00004 3.66666 8.00004C3.75507 8.00004 3.83985 7.96492 3.90236 7.90241C3.96488 7.8399 3.99999 7.75511 3.99999 7.66671C3.99999 7.4899 4.07023 7.32033 4.19526 7.1953C4.32028 7.07028 4.48985 7.00004 4.66666 7.00004C4.75507 7.00004 4.83985 6.96492 4.90236 6.90241C4.96488 6.8399 4.99999 6.75511 4.99999 6.66671C4.99999 6.5783 4.96488 6.49352 4.90236 6.431C4.83985 6.36849 4.75507 6.33337 4.66666 6.33337Z" fill="currentColor"/>
	<path id="Vector_3" d="M7.66667 4.00004C7.31304 4.00004 6.97391 3.85957 6.72386 3.60952C6.47381 3.35947 6.33333 3.02033 6.33333 2.66671C6.33333 2.5783 6.29821 2.49352 6.2357 2.43101C6.17319 2.36849 6.08841 2.33337 6 2.33337C5.91159 2.33337 5.82681 2.36849 5.7643 2.43101C5.70179 2.49352 5.66667 2.5783 5.66667 2.66671C5.66667 3.02033 5.52619 3.35947 5.27614 3.60952C5.02609 3.85957 4.68696 4.00004 4.33333 4.00004C4.24493 4.00004 4.16014 4.03516 4.09763 4.09767C4.03512 4.16018 4 4.24497 4 4.33337C4 4.42178 4.03512 4.50656 4.09763 4.56908C4.16014 4.63159 4.24493 4.66671 4.33333 4.66671C4.68696 4.66671 5.02609 4.80718 5.27614 5.05723C5.52619 5.30728 5.66667 5.64642 5.66667 6.00004C5.66667 6.08845 5.70179 6.17323 5.7643 6.23574C5.82681 6.29826 5.91159 6.33337 6 6.33337C6.08841 6.33337 6.17319 6.29826 6.2357 6.23574C6.29821 6.17323 6.33333 6.08845 6.33333 6.00004C6.33333 5.64642 6.47381 5.30728 6.72386 5.05723C6.97391 4.80718 7.31304 4.66671 7.66667 4.66671C7.75507 4.66671 7.83986 4.63159 7.90237 4.56908C7.96488 4.50656 8 4.42178 8 4.33337C8 4.24497 7.96488 4.16018 7.90237 4.09767C7.83986 4.03516 7.75507 4.00004 7.66667 4.00004Z" fill="currentColor"/>
</g>

<?php
$this->template( 'components/icons/icon/end' );
