<?php
/**
 * View: Points plus icon.
 *
 * @since 4.21.0
 * @version 4.21.0
 *
 * @var string[] $classes        Additional classes to add to the svg icon.
 * @var string   $label          The label for the icon.
 * @var bool     $is_aria_hidden Whether the icon is hidden from screen readers. Default false to show the icon.
 * @var Template $this           The template instance.
 *
 * @package LearnDash\Core
 */

use LearnDash\Core\Template\Template;

$svg_classes = [ 'ld-svgicon__points-plus' ];

if ( ! empty( $classes ) ) {
	$svg_classes = array_merge( $svg_classes, $classes );
}

if ( empty( $label ) ) {
	$label = __( 'Points plus icon', 'learndash' );
}

$this->template(
	'components/icons/icon/start',
	[
		'classes' => $svg_classes,
		'height'  => 17,
		'label'   => $label,
		'width'   => 16,
	],
);
?>

<path fill-rule="evenodd" clip-rule="evenodd" d="M8.55041 5.53085C8.32263 5.07826 7.6765 5.07826 7.44873 5.53085L6.76148 6.89641L5.43204 7.06151C4.94009 7.1226 4.71766 7.70976 5.04564 8.08147L5.98629 9.14755L5.72196 10.688C5.63674 11.1846 6.1508 11.5682 6.60265 11.3452L7.99957 10.6558L9.39649 11.3452C9.84834 11.5682 10.3624 11.1846 10.2772 10.688L10.0128 9.14755L10.9535 8.08147C11.2815 7.70976 11.059 7.1226 10.5671 7.06151L9.23765 6.89641L8.55041 5.53085ZM8.0565 6.82235C8.03188 6.77342 7.96203 6.77342 7.9374 6.82235L7.45061 7.78961C7.44061 7.80948 7.42136 7.82305 7.39928 7.8258L6.44255 7.9446C6.38937 7.95121 6.36532 8.01469 6.40078 8.05487L7.06294 8.80532C7.07629 8.82045 7.08207 8.84081 7.07866 8.8607L6.89439 9.93452C6.88518 9.98821 6.94075 10.0297 6.9896 10.0056L7.96745 9.52301C7.98605 9.51383 8.00786 9.51383 8.02646 9.52301L9.00431 10.0056C9.05315 10.0297 9.10873 9.98821 9.09951 9.93452L8.91525 8.8607C8.91184 8.84081 8.91762 8.82045 8.93097 8.80532L9.59313 8.05487C9.62858 8.01469 9.60454 7.95121 9.55135 7.9446L8.59463 7.8258C8.57255 7.82305 8.5533 7.80948 8.54329 7.78961L8.0565 6.82235Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M11.15 4.58333C11.2052 4.58333 11.25 4.6281 11.25 4.68333L11.25 5.73333C11.25 5.78856 11.2948 5.83333 11.35 5.83333H11.9833C12.0386 5.83333 12.0833 5.78856 12.0833 5.73333V4.68333C12.0833 4.6281 12.1281 4.58333 12.1833 4.58333H13.2333C13.2886 4.58333 13.3333 4.53856 13.3333 4.48333V3.85C13.3333 3.79477 13.2886 3.75 13.2333 3.75H12.1833C12.1281 3.75 12.0833 3.70523 12.0833 3.65V2.6C12.0833 2.54477 12.0386 2.5 11.9833 2.5L11.35 2.5C11.2948 2.5 11.25 2.54477 11.25 2.6L11.25 3.65C11.25 3.70523 11.2052 3.75 11.15 3.75H10.1C10.0448 3.75 10 3.79477 10 3.85V4.48333C10 4.53856 10.0448 4.58333 10.1 4.58333H11.15Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M11.753 6.33464C12.1217 6.97201 12.3327 7.71201 12.3327 8.5013C12.3327 10.8945 10.3926 12.8346 7.99935 12.8346C5.60612 12.8346 3.66602 10.8945 3.66602 8.5013C3.66602 6.10807 5.60612 4.16797 7.99935 4.16797C8.52665 4.16797 9.03195 4.26215 9.49935 4.43461V3.8513C9.49935 3.68924 9.5636 3.54218 9.66803 3.43422C9.14308 3.26144 8.58213 3.16797 7.99935 3.16797C5.05383 3.16797 2.66602 5.55578 2.66602 8.5013C2.66602 11.4468 5.05383 13.8346 7.99935 13.8346C10.9449 13.8346 13.3327 11.4468 13.3327 8.5013C13.3327 7.50337 13.0586 6.56946 12.5816 5.77073C12.5629 6.0853 12.3019 6.33464 11.9827 6.33464H11.753Z" fill="currentColor"/>

<?php
$this->template( 'components/icons/icon/end' );
