<?php
/**
 * This contains all the classes we use
 *
 * @file
 * @package Learndas_Certificate_Builder
 */

// class map, use for autoload.

$base_dir = dirname( __DIR__ );

$class_map = array(
	'Certificate_Builder\\Traits\\IO'                      => $base_dir . '/src/traits/io.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\DeepCopy'                                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/DeepCopy.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Exception\\CloneException'                  => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Exception/CloneException.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Exception\\PropertyException'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Exception/PropertyException.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\Doctrine\\DoctrineCollectionFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineCollectionFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\Doctrine\\DoctrineEmptyCollectionFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineEmptyCollectionFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\Doctrine\\DoctrineProxyFilter'      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Doctrine/DoctrineProxyFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\Filter'                             => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/Filter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\KeepFilter'                         => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/KeepFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\ReplaceFilter'                      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/ReplaceFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Filter\\SetNullFilter'                      => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Filter/SetNullFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Matcher\\Doctrine\\DoctrineProxyMatcher'    => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/Doctrine/DoctrineProxyMatcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Matcher\\Matcher'                           => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/Matcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Matcher\\PropertyMatcher'                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyMatcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Matcher\\PropertyNameMatcher'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyNameMatcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Matcher\\PropertyTypeMatcher'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Matcher/PropertyTypeMatcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\Reflection\\ReflectionHelper'               => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/Reflection/ReflectionHelper.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\Date\\DateIntervalFilter'       => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Date/DateIntervalFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\ReplaceFilter'                  => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/ReplaceFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\ShallowCopyFilter'              => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/ShallowCopyFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\Spl\\SplDoublyLinkedList'       => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Spl/SplDoublyLinkedList.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\Spl\\SplDoublyLinkedListFilter' => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/Spl/SplDoublyLinkedListFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeFilter\\TypeFilter'                     => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeFilter/TypeFilter.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\TypeMatcher\\TypeMatcher'                   => $base_dir . '/external/myclabs/deep-copy/src/DeepCopy/TypeMatcher/TypeMatcher.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f001\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f001/A.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f001\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f001/B.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f002\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f002/A.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f003\\Foo'                                  => $base_dir . '/external/myclabs/deep-copy/fixtures/f003/Foo.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f004\\UnclonableItem'                       => $base_dir . '/external/myclabs/deep-copy/fixtures/f004/UnclonableItem.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f005\\Foo'                                  => $base_dir . '/external/myclabs/deep-copy/fixtures/f005/Foo.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f006\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f006/A.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f006\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f006/B.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f007\\FooDateInterval'                      => $base_dir . '/external/myclabs/deep-copy/fixtures/f007/FooDateInterval.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f007\\FooDateTimeZone'                      => $base_dir . '/external/myclabs/deep-copy/fixtures/f007/FooDateTimeZone.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f008\\A'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f008/A.php',
	'LearnDash\\Certificate_Builder\\DeepCopy\\f008\\B'                                    => $base_dir . '/external/myclabs/deep-copy/fixtures/f008/B.php',
	'Error'                                                => $base_dir . '/external/paragonie/random_compat/lib/error_polyfill.php',
	'LearnDash_Certificate_Builder\\Bootstrap'             => $base_dir . '/src/class-bootstrap.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Block' => $base_dir . '/src/component/pdf/blocks/class-block.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Columns' => $base_dir . '/src/component/pdf/blocks/class-core-columns.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Heading' => $base_dir . '/src/component/pdf/blocks/class-core-heading.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Paragraph' => $base_dir . '/src/component/pdf/blocks/class-core-paragraph.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Core_Spacer' => $base_dir . '/src/component/pdf/blocks/class-core-spacer.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Fallback' => $base_dir . '/src/component/pdf/blocks/class-fallback.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Quizinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-quizinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Courseinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-courseinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Groupinfo' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-groupinfo.php',
	'LearnDash_Certificate_Builder\\Component\\Builder\\Pdf\\Blocks\\Learndash_Ld_Usermeta' => $base_dir . '/src/component/pdf/blocks/class-learndash-ld-usermeta.php',
	'LearnDash_Certificate_Builder\\Component\\PDF'        => $base_dir . '/src/component/class-pdf.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Builder' => $base_dir . '/src/component/pdf/builder/builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Html_Builder' => $base_dir . '/src/component/pdf/builder/class-html-builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Builder\\Style_Builder' => $base_dir . '/src/component/pdf/builder/class-style-builder.php',
	'LearnDash_Certificate_Builder\\Component\\Pdf\\Pdf_Content' => $base_dir . '/src/component/pdf/class-pdf-content.php',
	'LearnDash_Certificate_Builder\\Controller\\Certificate_Builder' => $base_dir . '/src/controller/class-certificate-builder.php',
	'LearnDash_Certificate_Builder\\Controller\\Fonts_Manager' => $base_dir . '/src/controller/class-fonts-manager.php',
	'LearnDash_Certificate_Builder\\Controller\\Switcher'  => $base_dir . '/src/controller/class-switcher.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode'                                        => $base_dir . '/external/mpdf/mpdf/src/Barcode.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\AbstractBarcode'                       => $base_dir . '/external/mpdf/mpdf/src/Barcode/AbstractBarcode.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\BarcodeException'                      => $base_dir . '/external/mpdf/mpdf/src/Barcode/BarcodeException.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\BarcodeInterface'                      => $base_dir . '/external/mpdf/mpdf/src/Barcode/BarcodeInterface.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Codabar'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Codabar.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Code11'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code11.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Code128'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code128.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Code39'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code39.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Code93'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Code93.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\EanExt'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/EanExt.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\EanUpc'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/EanUpc.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\I25'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/I25.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Imb'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/Imb.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Msi'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/Msi.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Postnet'                               => $base_dir . '/external/mpdf/mpdf/src/Barcode/Postnet.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\Rm4Scc'                                => $base_dir . '/external/mpdf/mpdf/src/Barcode/Rm4Scc.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Barcode\\S25'                                   => $base_dir . '/external/mpdf/mpdf/src/Barcode/S25.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Cache'                                          => $base_dir . '/external/mpdf/mpdf/src/Cache.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Color\\ColorConverter'                          => $base_dir . '/external/mpdf/mpdf/src/Color/ColorConverter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Color\\ColorModeConverter'                      => $base_dir . '/external/mpdf/mpdf/src/Color/ColorModeConverter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Color\\ColorSpaceRestrictor'                    => $base_dir . '/external/mpdf/mpdf/src/Color/ColorSpaceRestrictor.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Color\\NamedColors'                             => $base_dir . '/external/mpdf/mpdf/src/Color/NamedColors.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Config\\ConfigVariables'                        => $base_dir . '/external/mpdf/mpdf/src/Config/ConfigVariables.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Config\\FontVariables'                          => $base_dir . '/external/mpdf/mpdf/src/Config/FontVariables.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Conversion\\DecToAlpha'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToAlpha.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Conversion\\DecToCjk'                           => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToCjk.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Conversion\\DecToHebrew'                        => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToHebrew.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Conversion\\DecToOther'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToOther.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Conversion\\DecToRoman'                         => $base_dir . '/external/mpdf/mpdf/src/Conversion/DecToRoman.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\CssManager'                                     => $base_dir . '/external/mpdf/mpdf/src/CssManager.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Css\\Border'                                    => $base_dir . '/external/mpdf/mpdf/src/Css/Border.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Css\\DefaultCss'                                => $base_dir . '/external/mpdf/mpdf/src/Css/DefaultCss.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Css\\TextVars'                                  => $base_dir . '/external/mpdf/mpdf/src/Css/TextVars.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\DirectWrite'                                    => $base_dir . '/external/mpdf/mpdf/src/DirectWrite.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Exception\\FontException'                       => $base_dir . '/external/mpdf/mpdf/src/Exception/FontException.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Exception\\InvalidArgumentException'            => $base_dir . '/external/mpdf/mpdf/src/Exception/InvalidArgumentException.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\File\\StreamWrapperChecker'                     => $base_dir . '/external/mpdf/mpdf/src/File/StreamWrapperChecker.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Fonts\\FontCache'                               => $base_dir . '/external/mpdf/mpdf/src/Fonts/FontCache.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Fonts\\FontFileFinder'                          => $base_dir . '/external/mpdf/mpdf/src/Fonts/FontFileFinder.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Fonts\\GlyphOperator'                           => $base_dir . '/external/mpdf/mpdf/src/Fonts/GlyphOperator.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Fonts\\MetricsGenerator'                        => $base_dir . '/external/mpdf/mpdf/src/Fonts/MetricsGenerator.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Form'                                           => $base_dir . '/external/mpdf/mpdf/src/Form.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\FpdiTrait'                                      => $base_dir . '/external/mpdf/mpdf/src/FpdiTrait.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\ColorTable'                                => $base_dir . '/external/mpdf/mpdf/src/Gif/ColorTable.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\FileHeader'                                => $base_dir . '/external/mpdf/mpdf/src/Gif/FileHeader.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\Gif'                                       => $base_dir . '/external/mpdf/mpdf/src/Gif/Gif.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\Image'                                     => $base_dir . '/external/mpdf/mpdf/src/Gif/Image.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\ImageHeader'                               => $base_dir . '/external/mpdf/mpdf/src/Gif/ImageHeader.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gif\\Lzw'                                       => $base_dir . '/external/mpdf/mpdf/src/Gif/Lzw.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Gradient'                                       => $base_dir . '/external/mpdf/mpdf/src/Gradient.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\HTMLParserMode'                                 => $base_dir . '/external/mpdf/mpdf/src/HTMLParserMode.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Hyphenator'                                     => $base_dir . '/external/mpdf/mpdf/src/Hyphenator.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Image\\Bmp'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Bmp.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Image\\ImageProcessor'                          => $base_dir . '/external/mpdf/mpdf/src/Image/ImageProcessor.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Image\\ImageTypeGuesser'                        => $base_dir . '/external/mpdf/mpdf/src/Image/ImageTypeGuesser.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Image\\Svg'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Svg.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Image\\Wmf'                                     => $base_dir . '/external/mpdf/mpdf/src/Image/Wmf.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Language\\LanguageToFont'                       => $base_dir . '/external/mpdf/mpdf/src/Language/LanguageToFont.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Language\\LanguageToFontInterface'              => $base_dir . '/external/mpdf/mpdf/src/Language/LanguageToFontInterface.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Language\\ScriptToLanguage'                     => $base_dir . '/external/mpdf/mpdf/src/Language/ScriptToLanguage.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Language\\ScriptToLanguageInterface'            => $base_dir . '/external/mpdf/mpdf/src/Language/ScriptToLanguageInterface.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Log\\Context'                                   => $base_dir . '/external/mpdf/mpdf/src/Log/Context.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Mpdf'                                           => $base_dir . '/external/mpdf/mpdf/src/Mpdf.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\MpdfException'                                  => $base_dir . '/external/mpdf/mpdf/src/MpdfException.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\MpdfImageException'                             => $base_dir . '/external/mpdf/mpdf/src/MpdfImageException.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Otl'                                            => $base_dir . '/external/mpdf/mpdf/src/Otl.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\OtlDump'                                        => $base_dir . '/external/mpdf/mpdf/src/OtlDump.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Output\\Destination'                            => $base_dir . '/external/mpdf/mpdf/src/Output/Destination.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\PageFormat'                                     => $base_dir . '/external/mpdf/mpdf/src/PageFormat.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Pdf\\Protection'                                => $base_dir . '/external/mpdf/mpdf/src/Pdf/Protection.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Pdf\\Protection\\UniqidGenerator'               => $base_dir . '/external/mpdf/mpdf/src/Pdf/Protection/UniqidGenerator.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\RemoteContentFetcher'                           => $base_dir . '/external/mpdf/mpdf/src/RemoteContentFetcher.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\ServiceFactory'                                 => $base_dir . '/external/mpdf/mpdf/src/ServiceFactory.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Shaper\\Indic'                                  => $base_dir . '/external/mpdf/mpdf/src/Shaper/Indic.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Shaper\\Myanmar'                                => $base_dir . '/external/mpdf/mpdf/src/Shaper/Myanmar.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Shaper\\Sea'                                    => $base_dir . '/external/mpdf/mpdf/src/Shaper/Sea.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\SizeConverter'                                  => $base_dir . '/external/mpdf/mpdf/src/SizeConverter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Strict'                                         => $base_dir . '/external/mpdf/mpdf/src/Strict.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\TTFontFile'                                     => $base_dir . '/external/mpdf/mpdf/src/TTFontFile.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\TTFontFileAnalysis'                             => $base_dir . '/external/mpdf/mpdf/src/TTFontFileAnalysis.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\TableOfContents'                                => $base_dir . '/external/mpdf/mpdf/src/TableOfContents.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag'                                            => $base_dir . '/external/mpdf/mpdf/src/Tag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\A'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/A.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Acronym'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Acronym.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Address'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Address.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Annotation'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/Annotation.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Article'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Article.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Aside'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Aside.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\B'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/B.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\BarCode'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/BarCode.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Bdi'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Bdi.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Bdo'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Bdo.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Big'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Big.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\BlockQuote'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/BlockQuote.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\BlockTag'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/BlockTag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Bookmark'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/Bookmark.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Br'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Br.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Caption'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Caption.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Center'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Center.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Cite'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Cite.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Code'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Code.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\ColumnBreak'                               => $base_dir . '/external/mpdf/mpdf/src/Tag/ColumnBreak.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Columns'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Columns.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Dd'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dd.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Del'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Del.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Details'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Details.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Div'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Div.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Dl'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dl.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\DotTab'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/DotTab.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Dt'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Dt.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Em'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Em.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\FieldSet'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/FieldSet.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\FigCaption'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/FigCaption.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Figure'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Figure.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Font'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Font.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Footer'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Footer.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Form'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Form.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\FormFeed'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/FormFeed.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H1'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H1.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H2'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H2.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H3'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H3.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H4'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H4.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H5'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H5.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\H6'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/H6.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\HGroup'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/HGroup.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Header'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Header.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Hr'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Hr.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\I'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/I.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Img'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Img.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\IndexEntry'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/IndexEntry.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\IndexInsert'                               => $base_dir . '/external/mpdf/mpdf/src/Tag/IndexInsert.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\InlineTag'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/InlineTag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Input'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Input.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Ins'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Ins.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Kbd'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Kbd.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Legend'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Legend.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Li'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Li.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Main'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Main.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Mark'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Mark.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Meter'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Meter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Nav'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Nav.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\NewColumn'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/NewColumn.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\NewPage'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/NewPage.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Ol'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Ol.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Option'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Option.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\P'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/P.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\PageBreak'                                 => $base_dir . '/external/mpdf/mpdf/src/Tag/PageBreak.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\PageFooter'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/PageFooter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\PageHeader'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/PageHeader.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Pre'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Pre.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Progress'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/Progress.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Q'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/Q.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\S'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/S.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Samp'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Samp.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Section'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Section.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Select'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Select.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\SetHtmlPageFooter'                         => $base_dir . '/external/mpdf/mpdf/src/Tag/SetHtmlPageFooter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\SetHtmlPageHeader'                         => $base_dir . '/external/mpdf/mpdf/src/Tag/SetHtmlPageHeader.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\SetPageFooter'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SetPageFooter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\SetPageHeader'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SetPageHeader.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Small'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Small.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Span'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Span.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Strike'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Strike.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Strong'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/Strong.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Sub'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Sub.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\SubstituteTag'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/SubstituteTag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Summary'                                   => $base_dir . '/external/mpdf/mpdf/src/Tag/Summary.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Sup'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Sup.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TBody'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/TBody.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TFoot'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/TFoot.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\THead'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/THead.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Table'                                     => $base_dir . '/external/mpdf/mpdf/src/Tag/Table.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Tag'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Td'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Td.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TextArea'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/TextArea.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TextCircle'                                => $base_dir . '/external/mpdf/mpdf/src/Tag/TextCircle.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Th'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Th.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Time'                                      => $base_dir . '/external/mpdf/mpdf/src/Tag/Time.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Toc'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Toc.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TocEntry'                                  => $base_dir . '/external/mpdf/mpdf/src/Tag/TocEntry.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\TocPageBreak'                              => $base_dir . '/external/mpdf/mpdf/src/Tag/TocPageBreak.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Tr'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Tr.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Tt'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Tt.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Tta'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tta.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Tts'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Tts.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Ttz'                                       => $base_dir . '/external/mpdf/mpdf/src/Tag/Ttz.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\U'                                         => $base_dir . '/external/mpdf/mpdf/src/Tag/U.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\Ul'                                        => $base_dir . '/external/mpdf/mpdf/src/Tag/Ul.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\VarTag'                                    => $base_dir . '/external/mpdf/mpdf/src/Tag/VarTag.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\WatermarkImage'                            => $base_dir . '/external/mpdf/mpdf/src/Tag/WatermarkImage.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Tag\\WatermarkText'                             => $base_dir . '/external/mpdf/mpdf/src/Tag/WatermarkText.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Ucdn'                                           => $base_dir . '/external/mpdf/mpdf/src/Ucdn.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Utils\\Arrays'                                  => $base_dir . '/external/mpdf/mpdf/src/Utils/Arrays.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Utils\\NumericString'                           => $base_dir . '/external/mpdf/mpdf/src/Utils/NumericString.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Utils\\PdfDate'                                 => $base_dir . '/external/mpdf/mpdf/src/Utils/PdfDate.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Utils\\UtfString'                               => $base_dir . '/external/mpdf/mpdf/src/Utils/UtfString.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\BackgroundWriter'                       => $base_dir . '/external/mpdf/mpdf/src/Writer/BackgroundWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\BaseWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/BaseWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\BookmarkWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/BookmarkWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\ColorWriter'                            => $base_dir . '/external/mpdf/mpdf/src/Writer/ColorWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\FontWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/FontWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\FormWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/FormWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\ImageWriter'                            => $base_dir . '/external/mpdf/mpdf/src/Writer/ImageWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\JavaScriptWriter'                       => $base_dir . '/external/mpdf/mpdf/src/Writer/JavaScriptWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\MetadataWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/MetadataWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\ObjectWriter'                           => $base_dir . '/external/mpdf/mpdf/src/Writer/ObjectWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\OptionalContentWriter'                  => $base_dir . '/external/mpdf/mpdf/src/Writer/OptionalContentWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\PageWriter'                             => $base_dir . '/external/mpdf/mpdf/src/Writer/PageWriter.php',
	'LearnDash\\Certificate_Builder\\Mpdf\\Writer\\ResourceWriter'                         => $base_dir . '/external/mpdf/mpdf/src/Writer/ResourceWriter.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\AbstractLogger'                             => $base_dir . '/external/psr/log/Psr/Log/AbstractLogger.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\InvalidArgumentException'                   => $base_dir . '/external/psr/log/Psr/Log/InvalidArgumentException.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\LogLevel'                                   => $base_dir . '/external/psr/log/Psr/Log/LogLevel.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\LoggerAwareInterface'                       => $base_dir . '/external/psr/log/Psr/Log/LoggerAwareInterface.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\LoggerAwareTrait'                           => $base_dir . '/external/psr/log/Psr/Log/LoggerAwareTrait.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\LoggerInterface'                            => $base_dir . '/external/psr/log/Psr/Log/LoggerInterface.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\LoggerTrait'                                => $base_dir . '/external/psr/log/Psr/Log/LoggerTrait.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\NullLogger'                                 => $base_dir . '/external/psr/log/Psr/Log/NullLogger.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\Test\\DummyTest'                            => $base_dir . '/external/psr/log/Psr/Log/Test/DummyTest.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\Test\\LoggerInterfaceTest'                  => $base_dir . '/external/psr/log/Psr/Log/Test/LoggerInterfaceTest.php',
	'LearnDash\\Certificate_Builder\\Psr\\Log\\Test\\TestLogger'                           => $base_dir . '/external/psr/log/Psr/Log/Test/TestLogger.php',
	'TypeError'                                            => $base_dir . '/external/paragonie/random_compat/lib/error_polyfill.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\FpdfTpl'                              => $base_dir . '/external/setasign/fpdi/src/FpdfTpl.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\FpdfTplTrait'                         => $base_dir . '/external/setasign/fpdi/src/FpdfTplTrait.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\Fpdi'                                 => $base_dir . '/external/setasign/fpdi/src/Fpdi.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\FpdiException'                        => $base_dir . '/external/setasign/fpdi/src/FpdiException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\FpdiTrait'                            => $base_dir . '/external/setasign/fpdi/src/FpdiTrait.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\AbstractReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/AbstractReader.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\CrossReference' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/CrossReference.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\CrossReferenceException' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/CrossReferenceException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\FixedReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/FixedReader.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\LineReader' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/LineReader.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\CrossReference\\ReaderInterface' => $base_dir . '/external/setasign/fpdi/src/PdfParser/CrossReference/ReaderInterface.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\Ascii85'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Ascii85.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\Ascii85Exception'  => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Ascii85Exception.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\AsciiHex'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/AsciiHex.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\FilterException'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FilterException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\FilterInterface'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FilterInterface.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\Flate'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Flate.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\FlateException'    => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/FlateException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\Lzw'               => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/Lzw.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Filter\\LzwException'      => $base_dir . '/external/setasign/fpdi/src/PdfParser/Filter/LzwException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\PdfParser'                 => $base_dir . '/external/setasign/fpdi/src/PdfParser/PdfParser.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\PdfParserException'        => $base_dir . '/external/setasign/fpdi/src/PdfParser/PdfParserException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\StreamReader'              => $base_dir . '/external/setasign/fpdi/src/PdfParser/StreamReader.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Tokenizer'                 => $base_dir . '/external/setasign/fpdi/src/PdfParser/Tokenizer.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfArray'            => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfArray.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfBoolean'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfBoolean.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfDictionary'       => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfDictionary.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfHexString'        => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfHexString.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfIndirectObject'   => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfIndirectObject.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfIndirectObjectReference' => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfIndirectObjectReference.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfName'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfName.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfNull'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfNull.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfNumeric'          => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfNumeric.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfStream'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfStream.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfString'           => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfString.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfToken'            => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfToken.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfType'             => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfType.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfParser\\Type\\PdfTypeException'    => $base_dir . '/external/setasign/fpdi/src/PdfParser/Type/PdfTypeException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfReader\\DataStructure\\Rectangle'  => $base_dir . '/external/setasign/fpdi/src/PdfReader/DataStructure/Rectangle.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfReader\\Page'                      => $base_dir . '/external/setasign/fpdi/src/PdfReader/Page.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfReader\\PageBoundaries'            => $base_dir . '/external/setasign/fpdi/src/PdfReader/PageBoundaries.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfReader\\PdfReader'                 => $base_dir . '/external/setasign/fpdi/src/PdfReader/PdfReader.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\PdfReader\\PdfReaderException'        => $base_dir . '/external/setasign/fpdi/src/PdfReader/PdfReaderException.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\TcpdfFpdi'                            => $base_dir . '/external/setasign/fpdi/src/TcpdfFpdi.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\Tcpdf\\Fpdi'                          => $base_dir . '/external/setasign/fpdi/src/Tcpdf/Fpdi.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\Tfpdf\\FpdfTpl'                       => $base_dir . '/external/setasign/fpdi/src/Tfpdf/FpdfTpl.php',
	'LearnDash\\Certificate_Builder\\setasign\\Fpdi\\Tfpdf\\Fpdi'                          => $base_dir . '/external/setasign/fpdi/src/Tfpdf/Fpdi.php',
	'LearnDash\\Certificate_Builder\\simplehtmldom\\Debug'                                 => $base_dir . '/external/simplehtmldom/simplehtmldom/Debug.php',
	'LearnDash\\Certificate_Builder\\simplehtmldom\\HtmlDocument'                          => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlDocument.php',
	'LearnDash\\Certificate_Builder\\simplehtmldom\\HtmlNode'                              => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlNode.php',
	'LearnDash\\Certificate_Builder\\simplehtmldom\\HtmlWeb'                               => $base_dir . '/external/simplehtmldom/simplehtmldom/HtmlWeb.php',
);


spl_autoload_register(
	function ( $class ) use ( $class_map ) {
		if ( isset( $class_map[ $class ] ) ) {
			require_once $class_map[ $class ];
		}
	}
);
